#include "../binary_c.h"

/*
 * Initialise the star struct, except the star number 
 * (which must be set elsewhere) 
 */

void init_star(struct stardata_t * const stardata,
               struct star_t * const star)
{
    /*
     * Most parameters are zero or NULL by default at the start,
     * we can set these with a memset on *star
     */
    memset(star,0,sizeof(*star)); 
    star->num_thermal_pulses=-1.0;
    
#ifdef NUCSYN
    star->temp_mult=1.0;    
    /*
     * Set variables which require non-zero defaults
     */

    star->sn_last_time=-1;
    star->he_t=-1.0; // zero age helium star birth time
    star->newhestar=TRUE;
    star->hezamsmetallicity=-1.0;
    star->effective_zams_mass=star->mass;
    star->pms_mass=star->mass;
    star->start_HG_mass=-10;
#ifdef NUCSYN_FIRST_DREDGE_UP_PHASE_IN
    star->first_dup_phase_in_firsttime=TRUE;
#endif // NUCSYN_FIRST_DREDGE_UP_PHASE_IN 
    star->max_mix_depth=1e3;
    
#endif /* NUCSYN */
    star->stellar_type = MAIN_SEQUENCE;
    star->nova = NOVA_STATE_NONE;
    Dprint("Done for this star\n");
}
