#include "../binary_c.h"

/*
 * Initialize the model struct, but preserve the log_fp 
 * file pointer
 */

void init_model(struct model_t * RESTRICT const model)
{

#ifdef FILE_LOG
    FILE *fp = model->log_fp;
#endif
    memset(model,0,sizeof(*model));
#ifdef FILE_LOG
    model->log_fp = fp;
#endif

    model->probability = 1.0;

#ifdef RLOF_ABC   
    model->rlof_type = RLOF_NONE;
    model->do_rlof_log = FALSE;
    model->rlof_count = 0;
#endif
#ifdef BINARY_C_API
    model->id_number=-1; // default to -1
#endif
    int i;
    for(i=0;i<NLOGFLAGS;i++)
    {
        model->logflags[i] = FALSE;
        model->logstack[i] = LOG_NONE;
        model->logflagstrings[i][0] = '\0';
    }
    model->dt_zoomfac = 1.0;

#ifdef ZW2019_SNIA_LOG
    model->ZW2019_Hestar = -1;
    model->ZW2019_COWD = -1;
#endif // ZW2019_SNIA_LOG    
}


