#include "../binary_c.h"

void init_common(struct stardata_t * RESTRICT const stardata)
{
    struct common_t * common=&(stardata->common);
    
    /*
     * initialize the common struct
     */

#ifdef DISCS
    remove_discs(DISC_CIRCUMBINARY,common);
#endif

    /* the following are the actual settings */
    common->orbit.angular_momentum=0.0;
    common->orbit.angular_frequency=0.0;
    common->orbit.separation=0.0;
    common->orbit.period=0.0;
    common->orbit.eccentricity=0.0;
    common->orbit.tcirc = 0.0;
    common->RLOF_speed_up_factor=0.0;
    common->zams_eccentricity=0.0;
    common->zams_separation=0.0;
    common->diffstats_set = FALSE;
    common->done_single_star_lifetime = 0;
    Safe_free(common->file_log_prevstring);
    memset(common->file_log_prevtype,
           0,
           20*sizeof(char));
    memset(stardata->common.prevflags,
           0,
           NLOG_LABELS*sizeof(Boolean));
    memset(stardata->common.lockflags,
           0,
           sizeof(Boolean)*(NLOCKFLAGS+1)*NUMBER_OF_STARS);

#ifdef NUCSYN
    common->nucsyn_metallicity = DEFAULT_TO_METALLICITY;
#endif
    common->effective_metallicity = DEFAULT_TO_METALLICITY;
        
    //common->random_seed=random_seed();
    if(common->random_seed==0) common->random_seed=random_seed();
  
#ifdef ADAPTIVE_RLOF
    common->mdot_RLOF_adaptive=0.0;
    common->mdot_RLOF_BSE=0.0;
#ifdef ADAPTIVE_RLOF_LOG
    common->used_rate =  RLOF_RATE_UNDEF;
    common->runaway_rlof = FALSE;
    common->thermal_cap = FALSE;
#endif
#endif
#ifdef VISCOUS_RLOF_TRIGGER_SMALLER_TIMESTEP
    common->viscous_RLOF_wants_smaller_timestep=FALSE;
#endif
    stardata->common.max_mass_for_second_dredgeup=DEFAULT_MAX_MASS_FOR_SECOND_DREDGEUP;

}
