#include "../binary_c.h"

void free_difflogstack(struct difflogstack_t * RESTRICT const logstack)
{
    /*
     * Free the local logstack and everything inside it.
     *
     * Note: we assume that clean_difflogstack has previously
     * been called on the stack, as it is in evolution_difflog.
     */
    if(logstack != NULL)
    {
        Safe_free(logstack->items);
        Unsafe_free(logstack);    
    }
}

