#include "../binary_c.h"

/*
 * The binary_c stellar population nucleosynthesis framework.
 *
 * Contact: r.izzard@surrey.ac.uk or rob.izzard@gmail.com
 *
 * http://personal.ph.surrey.ac.uk/~ri0005/binary_c.html
 * https://gitlab.eps.surrey.ac.uk/ri0005/binary_c
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-announce
 * https://groups.google.com/forum/#!forum/binary_c-nucsyn-devel
 * https://twitter.com/binary_c_code
 * https://www.facebook.com/groups/149489915089142/
 *
 * Please see the files README, LICENCE and CHANGES,
 * and the doc/ directory for documentation.
 *
 *
 * Binary_c's main loop to evolve a binary system in time.
 */

int evolve_system(struct stardata_t * RESTRICT const stardata)
{
    
    /* first time setup */
    if(stardata->model.model_number == 0)
    {
        pre_evolution(stardata);
    }
    
    stardata->evolving = TRUE;

    int retval = evolve_system_binary_c(stardata);
    
    post_evolution(stardata);

    return retval;
}
 
