#include "../binary_c.h"

int evolve_RLOFing_system(struct stardata_t * RESTRICT const stardata)
{
#ifdef RLOF_ABC
    RLOF_log(stardata);
#endif // RLOF_ABC

    /*
     * Update stellar masses, angular momenta and structure
     * to time t+dt
     */
    initialize_RLOFing_system_every_timestep(stardata);

    int status = evolution(stardata,RLOF_SYSTEM_CALL);
    printf("evolution returned status %d %s\n",status,
           status < 0 ? "next timestep will have dt=0" : ""
        );

    //remove me
    test_for_roche_lobe_overflow(stardata);

    int stop = 0;
    if(status < 0) 
    {
        stop = -status;
        status = STOP_LOOPING_RESULT;
    }
    else
    {
        if(check_reject_flags(stardata))
        {
            stop = LOOP_REJECT;
        }
        else if(status == KEEP_LOOPING_RESULT)
        {                
            /* Test whether the primary still fills its Roche lobe etc. */
            status = test_if_primary_still_fills_roche_lobe(stardata);

            if(status == CONTACT)
            { 
                /* Contact system */
                stop = (contact_system(stardata,FALSE)==END_ROCHE)
                    ? LOOP_NOW : LOOP;
            }
            else
            {
                /* continue normal RLOF */
                stop = (status==NO_CONTACT ? LOOP_RLOF : LOOP_NOW);
            }
        }
        else if(status == SYSTEM_IS_BROKEN_APART)
        {
            /* RLOF stops */
            stop = LOOP;
        }
        else if(status == STOP_LOOPING_RESULT)
        {
            /* stop condition caught */
            stop = STOP;
        }
    }

    /* 
     * Catch events, e.g. SNe, common envelope evolution
     */
    catch_events(stardata);

    if(stop == LOOP_REJECT)
    {

    }
    else if(status != STOP_LOOPING_RESULT)
    {
        /*
         * Check if the event terminated RLOF
         */
        status = test_if_primary_still_fills_roche_lobe(stardata);
        stop = status == CONTACT ? LOOP_NOW :
            status == NO_CONTACT ? LOOP_RLOF :
            END_ROCHE;
    }
    
    return stop;
}
