#include "../binary_c.h"


void evolution_time_explicit(struct stardata_t * RESTRICT const stardata)
{
    /*
     * We've converged on our system using whatever solver...
     * now we have to perform algorithms that only work
     * using a forward Euler type solver.
     *
     * Note: we could (in theory) set these as events, 
     * but it's easier to put them in here.
     */

    Star_number k;
    Starloop(k)
    {
        SETstar(k);
        struct star_t * prevstar MAYBE_UNUSED = &stardata->previous_stardata->star[k];

#ifdef BSE
        
        if(star->stellar_type == TPAGB)
        {
            double tagb = 1e6 * (star->age - star->time_first_pulse);

            /*
             * Integer number of pulses (but stored in a double)
             */
            double dntpf = 
                (tagb - star->time_prev_pulse)/
                (1e6 * star->interpulse_period);
            
            star->dntp =
                Max(0.0,
                    /* no next pulse time set */
                    Is_zero(star->time_next_pulse) ? 0.0 :
                    /* been through next dntpf pulses? */
                    tagb > star->time_next_pulse ? (double)((int)dntpf) :
                    /* has not been through the next pulse */
                    0.0);
            
            star->dntp = Max(0.0,star->dntp);

            star->num_thermal_pulses += star->dntp;
            
            Boolean above_mcmin;
            star->lambda_3dup = lambda_3dup(stardata,star,&above_mcmin);
                        
            if(star->dntp > 0.5)
            {
                /*
                 * Thermal pulse
                 */
                if(above_mcmin)
                {
                    /*
                     * Third dredge up
                     */
                    star->num_thermal_pulses_since_mcmin += star->dntp;
                    star->dm_3dup = star->lambda_3dup * (star->core_mass - star->Mc_prev_pulse); 
                }
                else
                {
                    /*
                     * No third dredge up
                     */
                    star->dm_3dup = 0.0;
                }
                /*
                 * Increse the thermal pulse count
                 */
                star->num_thermal_pulses += star->dntp;

                /*
                 * Save the core mass for the next time this function is called 
                 */
                star->Mc_prev_pulse = star->core_mass;

                /*
                 * Recalculate the interpulse period and 
                 * hence the time of the next pulse
                 */
                star->interpulse_period = 
                    Karakas2002_interpulse_period(stardata,
                                                  star->core_mass,
                                                  star->mass,
                                                  star->mc_1tp,
                                                  stardata->common.metallicity,
                                                  star->lambda_3dup,
                                                  star);
                star->time_prev_pulse = star->time_next_pulse;
                star->time_next_pulse = star->time_prev_pulse + 
                    star->dntp * 1e6 * star->interpulse_period;
                
            }
        }
#endif // BSE        
    }

}
