#include "../binary_c.h"

void evolution_success(struct stardata_t * RESTRICT const stardata)
{
    /*
     * The current stardata is good, i.e. not rejected.
     */

    modulate_zoomfac(stardata,
                     ZOOMFAC_INCREASE_TIMESTEP);

    
    Dprint("evolution succesful %d %30.20g %30.20g %30.20g %30.20g %g %g\n",
           stardata->model.model_number,
           stardata->model.time,
           stardata->model.dtm,
           stardata->model.dt_zoomfac,//4
           stardata->star[0].radius / stardata->star[0].roche_radius, //5
           Is_not_zero(stardata->common.orbit.angular_frequency) ? (stardata->star[0].omega / stardata->common.orbit.angular_frequency) : 0.0,//6
           Is_not_zero(stardata->common.orbit.angular_frequency) ? (stardata->star[1].omega / stardata->common.orbit.angular_frequency) : 0.0//7
        );
}
