

#include "../binary_c.h"

void evolution_restore_from_previous(struct stardata_t * RESTRICT const stardata)
{ 
    /*
     * Restore stardata from previous_stardata, if this is possible.
     *
     * Take note to erase the event stack first.
     */
    if(stardata->previous_stardata!=NULL)
    { 
        Star_number i;
        Starloop(i)
        {
            SETstar(i);
            Dprint("Star %d New supernova %p\n",
                   i,
                   star->new_supernova);
            free_supernova(stardata,star);
        }

        Dprint("Restore stardata from %p (t=%30.12e) onto %p (%30.12e)\n",
               stardata->previous_stardata,
               stardata->previous_stardata->model.time,
               stardata,
               stardata->model.time);

        erase_events(stardata);

        /*
         * Copy stardata, but preserve the previous_stardata stack
         * and stardata_stack
         */
        Dprint("Copy %p (%p) with prefs %p onto %p\n",
               stardata->previous_stardata,
               stardata->previous_stardatas[0],
               stardata->previous_stardata->preferences,
               stardata);

        copy_stardata(
            stardata->previous_stardata,
            stardata,
            COPY_STARDATA_MAINTAIN_TO_STACK_POINTERS
            );

        Dprint("Restored from previous\n");
    }
}
