#include "../binary_c.h"

void evolution_restore_and_reduce_timestep(struct stardata_t * RESTRICT const stardata)
{
    /*
     * Restore stardata from previous_stardata,
     * reduce its timestep, and reset its reject flag to FALSE.
     *
     *  Preserve the dt-zoomfac
     */
    const double dt_zoomfac = stardata->model.dt_zoomfac;
    
#ifdef LOG_REJECTIONS
    /*
     * Force logging of rejections *now*
     */
    const Reject_index reject_reason = Elvis3(stardata->model.reject,
                                              stardata->star[0].reject,
                                              stardata->star[1].reject);
    if(reject_reason)
    {
        char reject_label[STRING_LENGTH];
        const int x =
            snprintf(reject_label,
                     STRING_LENGTH-1,
                     "Reject %s->%s : restore to t=%30.20g (deltat=%g)",
                     (stardata->model.reject ? "model" :
                      stardata->star[0].reject ? "star0" :
                      stardata->star[1].reject ? "star1" :
                      "unknown"),
                     Reject_string(reject_reason),
                     stardata->previous_stardata->model.time,
                     stardata->previous_stardata->model.time - stardata->model.time
                );
        if(x<0)
        {
            reject_label[STRING_LENGTH-1] = '\0';
        }
        logwrap(stardata,reject_label);
    }
#endif // LOG_REJECTIONS

    evolution_restore_from_previous(stardata);

    Dprint("ZOOM : Restored to (stardata %p, prefs = %p, prev %p, prev->prefs %p) at t=%30.16g with dtm = %g (reject = %u, dt_RLOF = %g, zoom = %g) [R0=%g RL0=%g -> RLOF %s] [R1=%g RL1=%g -> RLOF %s] \n",
           stardata,
           stardata->preferences,
           stardata->previous_stardata,
           stardata->previous_stardata->preferences,
           stardata->model.time,
           stardata->model.dtm,
           stardata->model.reject,
           stardata->model.RLOF_recommended_timestep,
           stardata->model.dt_zoomfac,
           stardata->star[0].radius,
           stardata->star[0].roche_radius,
           Yesno(stardata->star[0].radius > stardata->star[0].roche_radius),
           stardata->star[1].radius,
           stardata->star[1].roche_radius,
           Yesno(stardata->star[1].radius > stardata->star[1].roche_radius)
        );

    /*
     * Restore the timestep zoom factor
     */
    stardata->model.dt_zoomfac = dt_zoomfac;

    /*
     * And reduce it to zoom in
     */
    modulate_zoomfac(stardata,
                     ZOOMFAC_DECREASE_TIMESTEP);

    stardata->model.dtm *= stardata->model.dt_zoomfac;
    stardata->model.reject = REJECT_NONE;
    
    Dprint("ZOOM new dtm = %g, dt_zoomfac = %g\n",
           stardata->model.dtm,
           stardata->model.dt_zoomfac);
    
    /* 
     * Timestep minimum
     */
    stardata->model.dtm = Max(stardata->preferences->minimum_timestep,
                              stardata->model.dtm);

}
