#pragma once
#ifndef EVOLUTION_PROTOTYPES_H
#define EVOLUTION_PROTOTYPES_H

#include "../binary_c_parameters.h"
#include "../binary_c_macros.h"
#include "../binary_c_structures.h"
#include "../binary_c_debug.h"

int evolution(struct stardata_t * RESTRICT const stardata,
              Evolution_system_type system_type);
void evolution_time_zero_setup(struct stardata_t * RESTRICT const stardata);
int evolve_system(struct stardata_t * RESTRICT const stardata);
int evolve_system_binary_c(struct stardata_t * RESTRICT const stardata);
int evolve_detached_system(struct stardata_t * RESTRICT const stardata,
                           Boolean * RESTRICT initialize);
int evolve_RLOFing_system(struct stardata_t * RESTRICT const stardata);
int stellar_evolution(struct stardata_t * RESTRICT const stardata,
                      const int codetype);
void binary_star_evolution(struct stardata_t * RESTRICT const stardata,
                           int * RESTRICT const retval);
void initialize_parameters(struct stardata_t * RESTRICT const stardata);
void reinitialize_parameters(struct stardata_t * RESTRICT const stardata);
void set_next_timestep(struct stardata_t * RESTRICT const stardata);
Boolean loop_evolution(struct stardata_t * RESTRICT const stardata);
void end_of_evolution(struct stardata_t * RESTRICT const stardata);
void initialize_detached_system_every_timestep(struct stardata_t * RESTRICT const stardata);
void initialize_generic_system_every_timestep(struct stardata_t * RESTRICT const stardata);
Boolean Pure_function check_for_time_exhaustion(struct stardata_t * RESTRICT const stardata,
                                                const int intpol);
Boolean to_loop_or_not_to_loop(struct stardata_t * RESTRICT const stardata);
void update_time(struct stardata_t * RESTRICT const stardata);

void start_of_evolution(struct stardata_t * RESTRICT const stardata);
void init_star(struct stardata_t * const stardata,
               struct star_t * const star);
void init_model(struct model_t * RESTRICT const model);
void init_common(struct stardata_t * RESTRICT const stardata);

void evolution_nanchecks(struct stardata_t * RESTRICT const stardata);
Boolean Pure_function_if_no_debug system_is_observationally_single(struct stardata_t * RESTRICT const stardata);
void zero_derivatives(struct stardata_t * RESTRICT const stardata);
void evolution_cleanup(struct stardata_t * RESTRICT const stardata,
                       const Boolean free_pointers,
                       const Boolean close_logs);
int evolution_loop_top(struct stardata_t * RESTRICT const stardata);
void start_RLOF(struct stardata_t * RESTRICT const stardata);
void evolution_nucsyn(struct stardata_t * RESTRICT const stardata);
int loop_check(struct stardata_t * RESTRICT const stardata, const int stop);

void evolution_difflog(struct stardata_t * RESTRICT const stardata);


void evolution_save_to_previous(struct stardata_t * RESTRICT const stardata);
                                
void evolution_restore_from_previous(struct stardata_t * RESTRICT const stardata);
void evolution_restore_and_reduce_timestep(struct stardata_t * RESTRICT const stardata);
                                           
int evolution_rejected(struct stardata_t * RESTRICT const stardata);
void evolution_success(struct stardata_t * RESTRICT const stardata);
int evolution_split(struct stardata_t * RESTRICT const stardata,
                    int * RESTRICT const status);

void zero_stellar_derivatives(struct stardata_t * RESTRICT const stardata);
void update_the_time(struct stardata_t * RESTRICT const stardata);
void update_phase_start_times(struct stardata_t * RESTRICT const stardata);
Boolean Pure_function check_reject_flags(struct stardata_t * RESTRICT const stardata);
void initialize_RLOFing_system_every_timestep(struct stardata_t * RESTRICT const stardata);
void zero_stellar_mass_and_angmom_derivatives(struct stardata_t * RESTRICT const stardata);




Boolean Pure_function_if_no_debug can_reject(struct stardata_t * RESTRICT const stardata);
void pre_evolution(struct stardata_t * RESTRICT const stardata);
void post_evolution(struct stardata_t * RESTRICT const stardata);
void evolution_time_explicit(struct stardata_t * RESTRICT const stardata);
void evolution_forward_Euler(struct stardata_t * RESTRICT const stardata);
void evolution_rejection_tests(struct stardata_t * RESTRICT const stardata);
void free_difflogstack(struct difflogstack_t * RESTRICT const logstack);

void terminate_evolution(struct stardata_t * const stardata,
                         const char * const message);

#endif /* EVOLUTION_PROTOTYPES_H */

