#include "../binary_c.h"


/* 
 * Initialize at the start of the timestep
 *
 * Return EVOLUTION_BREAK to stop evolution immediately, 
 * which should be unusual, otherwise return EVOLUTION_CONTINUE.
 */
int evolution_loop_top(struct stardata_t * RESTRICT const stardata)
{
#ifdef NO_IMMEDIATE_MERGERS
    if(THERE_IS_AN_IMMEDIATE_MERGER)
    {
        Dprint("Ending evolution() loop because there was an immediate merger\n");
        return EVOLUTION_BREAK;
    }
#endif

    Star_number k;
    Starloop(k)
    {
        stardata->star[k].SN_type = SN_NONE;
        stardata->star[k].reject = REJECT_NONE;
    }
    stardata->model.supernova = FALSE;
    stardata->model.solver_step = 0;
    stardata->model.reject = REJECT_NONE;
    stardata->model.RLOF_recommended_timestep = 0.0;
    
#if defined SELMA_FIX_ACCRETED_MASS_IN_REJUVENATION || \
     defined SELMA_BETTER_TREATMENT_OF_MS_ACCRETORS
    stardata->star[0].last_mass  = stardata->star[0].mass;
    stardata->star[1].last_mass  = stardata->star[1].mass;
#endif // SELMA_*
#ifdef RLOF_ABC
    stardata->model.do_rlof_log=FALSE;
#endif //RLOF_ABC
    stardata->model.comenv_type = 0;

    stardata->common.had_event = FALSE;
    
    return EVOLUTION_CONTINUE;
}

