#pragma once
#ifndef EVOLUTION_DIFFLOG_H
#define EVOLUTION_DIFFLOG_H

/*
 * Structs, macros and prototypes for the evolution difflog
 */

#define Stack_debug_print(...) /* do nothing */


#define RLOFing(D,K)                                                    \
    (                                                                   \
        (D)->stellar_type[(K)]!=MASSLESS_REMNANT &&                     \
        (D)->radius[(K)] > 0.0 &&                                       \
        (D)->roche_radius[(K)] > 0.0 &&                                 \
        Is_not_zero((D)->roche_radius[(K)]) &&                          \
        More_or_equal((D)->radius[(K)]  , (D)->roche_radius[(K)])       \
        )

static void set_diffstats(struct stardata_t * stardata,
                          struct diffstats_t * now);

static void cf_diffstats(struct stardata_t * RESTRICT const stardata,
                         struct diffstats_t * RESTRICT now,
                         struct diffstats_t * RESTRICT prev,
                         Boolean * RESTRICT flags,
                         Boolean * RESTRICT prevflags,
                         Boolean lockflags[NUMBER_OF_STARS][NLOCKFLAGS+1]);

static void dolog(struct stardata_t * RESTRICT const stardata,
                  const char * RESTRICT cin);

static void logging_dependencies(struct stardata_t * RESTRICT const stardata,
                                 Boolean * flags,
                                 Boolean lockflags[NUMBER_OF_STARS][NLOCKFLAGS+1]);

static void push_stacklog(struct difflogstack_t * logstack,
                          struct stardata_t * stardata,
                          const char * cin);

static int compare_logitems(const void * RESTRICT a,
                            const void * RESTRICT b,
                            void * arg);

static struct difflogstack_t * new_difflogstack(void);
static void clean_difflogstack(struct difflogstack_t * logstack);

#endif // EVOLUTION_DIFFLOG_H

