#include "../binary_c.h"

Boolean Pure_function check_reject_flags(struct stardata_t * RESTRICT const stardata)
{
    /*
     * Check global and stellar timestep reject flags,
     * return TRUE if any of them are TRUE.
     */
    Boolean reject = FALSE;

    if(can_reject(stardata) == TRUE)
    {
        if(stardata->model.reject != REJECT_NONE)
        {
            reject = TRUE;
            Dprint("Reject model at t=%g : why? %s\n",
                   stardata->model.time,
                   Reject_string(stardata->model.reject));
        }
        else
        {
            Star_number k;
            Starloop(k)
            {
                SETstar(k);
                if(star->reject != REJECT_NONE)
                {
                    reject = TRUE;
                    Dprint("Reject star%d at t=%g : why? %s\n",
                           k,
                           stardata->model.time,
                           Reject_string(star->reject));
                    break;
                }
            }
        }
    }

    return reject;
}
