#include "binary_c.h"

#define _Rejected_dtm (stardata->model.dt_zoomfac * stardata->model.dtm) 

#define _Timestep_large_enough                          \
    (_Rejected_dtm > stardata->preferences->minimum_timestep)

#define _No_events                                              \
    (stardata->common.had_event == FALSE                        \
     && stardata->previous_stardata != NULL                     \
     && stardata->previous_stardata->common.had_event == FALSE)

Boolean Pure_function_if_no_debug can_reject(struct stardata_t * RESTRICT const stardata)
{
    /*
     * Return TRUE if we're allowed to reject a timestep
     * and fall back on the old timestep
     *
     * can reject if we haven't hit the max number of rejections
     * and the new timestep will be larger than the minimum timestep
     *
     * can reject if we didn't have an event in the 
     * previous timestep: events can change the system
     * in a non-continuous way, which means we can never
     * converge
     */
    Boolean x = Boolean_(_Timestep_large_enough && _No_events);

    Dprint("at %30.20g model %d can we reject timestep? new dtm large enough? %s (would be %g vs minimum %g) : had event? %s\n",
           stardata->model.time,
           stardata->model.model_number,
           Yesno(_Timestep_large_enough),
           _Rejected_dtm,
           stardata->preferences->minimum_timestep,
           Yesno(_No_events));

    return x;
}
