#include "../binary_c.h"

void binary_star_evolution(struct stardata_t * RESTRICT const stardata,
                           int * RESTRICT const retval)
{
    /*
     * Having calculated stellar evolution, do 
     * binary-specific evolutionary tasks
     */
    if(stardata->common.orbit.eccentricity > 1.0)
    {
        *retval = SYSTEM_IS_BROKEN_APART;
    }

    if(*retval != SYSTEM_IS_BROKEN_APART)
    {
        /*
         * Update mass ratios, and Roche and effective radii
         */
        determine_mass_ratios(stardata);
        determine_roche_lobe_radii(stardata,&stardata->common.orbit);
        set_effective_radii(stardata);
    } 
}
