#include "../binary_c.h"
#include "binary_c_events.h"

void trigger_event(struct stardata_t * const stardata,
                   struct binary_c_event_t * const event)
{
    stardata->common.had_event = TRUE;
    stardata->common.current_event = event;
        
    Eprint("Event 0/%d = %p (func=%p data=%p)\n",
           stardata->common.n_events,
           event,
           event->func,
           event->data
        );
        
    /*
     * Call the events handler function with stardata
     * and the event data.
     */
    Eprint("call func with (stardata = %p, data = %p)\n",
           stardata,
           event->data);

  
    (*event->func)(event,
                   stardata,
                   event->data);
    
    Eprint("post func call : event = %p\n",event);
    Eprint("free the data at event = %p\n",event);
    Eprint("with data %p\n",event!=NULL ? event->data : NULL);
        
    /*
     * Free the data  
     */ 
    Safe_free(event->data);

    Eprint("free the event\n");
    
    /*
     * Free the event that has been caught, although don't NULL it
     */
    Unsafe_free(event);

    /*
     * Shift down the stack at 0
     */
    shift_event_stack(stardata,0);
        
    stardata->common.current_event = NULL;

}
