#pragma once
#ifndef EVENTS_PROTOTYPES_H
#define EVENTS_PROTOTYPES_H

void catch_events(struct stardata_t * RESTRICT const stardata);

void erase_events(struct stardata_t * RESTRICT const stardata);
void erase_event(struct stardata_t * RESTRICT const stardata,
                 struct binary_c_event_t ** RESTRICT const event);

int new_event(const char * RESTRICT const caller,
              struct stardata_t * const stardata,
              const Event_type type,
              Event_handler_function func(EVENT_HANDLER_ARGS),
              Event_handler_function erase_func(EVENT_HANDLER_ARGS),
              const void * data,
              const Boolean unique);

Boolean Pure_function events_pending_of_type(struct stardata_t * RESTRICT const stardata,
                                             const Event_type type);
Boolean Pure_function events_pending(struct stardata_t * RESTRICT const stardata);

char * event_stack_string(struct stardata_t * RESTRICT const stardata);

void erase_events_of_type(struct stardata_t * RESTRICT const stardata,
                          const Event_type type,
                          const struct binary_c_event_t * RESTRICT const except);
void shift_event_stack(struct stardata_t * RESTRICT const stardata,
                       const int n);

void trigger_event(struct stardata_t * const stardata,
                   struct binary_c_event_t * const event);
            


#endif // EVENTS_PROTOTYPES_H
