#include "../binary_c.h"
#include "binary_c_events.h"

/*
 * Return TRUE if there is an event pending
 * of the given type, FALSE otherwise
 */
Boolean Pure_function events_pending_of_type(struct stardata_t * RESTRICT const stardata,
                                             const Event_type type)
{
    Eprint("check for events pending of type %d ... ",type);
    Boolean ret = FALSE;
    if(stardata->common.n_events > 0)
    {
        int i;
        for(i=0;i<stardata->common.n_events;i++)
        {
            struct binary_c_event_t * ev = stardata->common.events[i];
            if(ev != NULL && ev->type == type)
            {
                ret = TRUE;
                break;
            }
        }
    }
    Eprint("Found ? %d\n",ret);
    return ret;
}
