#pragma once
#ifndef EVENTS_MACROS_H
#define EVENTS_MACROS_H

/*
 * A series of unique numbers for each event.
 * New events should be positive integers, i.e.
 * of Event_type (which is int).
 *
 * A NULL event should be BINARY_C_EVENT_NONE == 0.
 * 
 * -1 is reserved for BINARY_C_EVENT_ERASE_EVENTS
 */
#define BINARY_C_EVENT_ERASE_EVENTS -1
#define BINARY_C_EVENT_NONE 0
#define BINARY_C_EVENT_SUPERNOVA 1
#define BINARY_C_EVENT_NOVA 2
#define BINARY_C_EVENT_WIND 3
#define BINARY_C_EVENT_COMMON_ENVELOPE 4
#define BINARY_C_EVENT_RLOF_START 5
#define BINARY_C_EVENT_CONTACT_SYSTEM 6
#define BINARY_C_EVENT_UNSTABLE_RLOF 7

#define Binary_c_event_string(N) (                                      \
        (N) == BINARY_C_EVENT_ERASE_EVENTS ? "Erase" :                  \
        (N) ==  BINARY_C_EVENT_NONE ? "None" :                          \
        (N) ==  BINARY_C_EVENT_SUPERNOVA ? "Supernova" :                \
        (N) ==  BINARY_C_EVENT_NOVA ? "Nova":                           \
        (N) ==  BINARY_C_EVENT_WIND ? "Wind":                           \
        (N) ==  BINARY_C_EVENT_COMMON_ENVELOPE ? "Common envelope":     \
        (N) ==  BINARY_C_EVENT_RLOF_START ? "RLOF start" :              \
        (N) ==  BINARY_C_EVENT_CONTACT_SYSTEM ? "Contact system":       \
        (N) ==  BINARY_C_EVENT_UNSTABLE_RLOF ? "dynamical RLOF":        \
        "Unknown"                                                       \
        )

/*
 * An index to be returned when new events
 * are denied. Note this must be < 0.
 */
#define BINARY_C_EVENT_DENIED -1

/*
 * Macros for unique and non-unique events
 */
#define UNIQUE_EVENT (TRUE)
#define NORMAL_EVENT (FALSE)


#endif // EVENTS_MACROS_H
