#include "../binary_c.h"
#include "binary_c_events.h"

void erase_events_of_type(struct stardata_t * RESTRICT const stardata,
                          const Event_type type,
                          const struct binary_c_event_t * RESTRICT const except)
{
    /*
     * Erase any pending events of a given type without
     * triggering them, except even "except" which is 
     * a pointer to an event that must not be deleted. 
     *
     * If type is -1 then any type is removed.
     *
     * If except==NULL, it is ignored.
     *
     * Normally, except is set to stardata->common.current_event
     * so the current event cannot be erased while it's being
     * processed.
     */
    Eprint("Erase events of type %d (except %p) n = %d\n",
           type,
           except,
           stardata->common.n_events);
        
    int i;
    for(i=0;i<stardata->common.n_events;i++)
    {
        struct binary_c_event_t * event = stardata->common.events[i];
        Boolean do_erase = Boolean_((event != NULL) &&
                                    (except == NULL || event != except) &&
                                    (type==-1 || event->type == type));
        
        Eprint("event %d type %d want to match %d : non-NULL? %d : is exception? %d : of type? %d -> do_erase? %s\n",
               i,
               event ? event->type : -1,
               type,
               event != NULL,
               event == except,
               event ? (event->type == type) : -1,
               Yesno(do_erase));
                
        if(do_erase == TRUE)
        {
            /*
             * Do the erasing
             */
            Eprint("call erase event\n");
            erase_event(stardata,&event);
            
            stardata->common.events[i] = NULL;
        
            /*
             * Shift the stack at the current location
             */
            shift_event_stack(stardata,i);
        }
    }
}

