#include "../binary_c.h"
#include "binary_c_events.h"

/*
 * Erase the event at *eventp.
 *
 * eventp is a pointer to a pointer to the event structure.
 *
 * If its erase_func is set, call it.
 *
 * Then erase the event data and the event structure itself.  
 *
 * NOTE:
 * You should not call this function directly: use
 * erase_events() or erase_events_of_type() instead,
 * otherwise the event stack will be very confused!
 */

void erase_event(struct stardata_t * RESTRICT const stardata,
                 struct binary_c_event_t ** RESTRICT const eventp)
{
    struct binary_c_event_t * event = eventp != NULL ? *eventp : NULL;

    Eprint("Erase event %p (from eventp = %p): erase_func = %p\n",
           event,
           eventp,
           event ? event->erase_func : NULL);
    
    if(eventp != NULL && event != NULL)
    {
        /*
         * If there is one, call the erase function
         */   
        if(*event->erase_func != NULL)
        {
            (*event->erase_func)(event,
                                 stardata,
                                 event->data);
        }
    
        /*
         * Free the data  
         */ 
        Safe_free(event->data);

        /*
         * Free the event itself
         */
        Safe_free(event);
    }
}
