#include "../binary_c.h"
#include "binary_c_events.h"

void catch_events(struct stardata_t * RESTRICT const stardata)
{
    /*
     * Catch system-wide events.
     *
     * The events are in a stack at stardata->common.events
     * and we handle them one by one in the order they are
     * stacked.
     *
     * Each has a handler function assigned to it, which is 
     * called with stardata and the associated data (which may
     * be NULL) as arguments.
     *
     * Note: if we're on an intermediate solution step, we cannot
     * process events. Instead, we simply delete the event stack
     * and let the final step deal with it.
     */

    if(stardata->model.intermediate_step == FALSE)
    {
        const int vb = 0;
        unsigned int k;
        if(vb)
        {
            for(k=0; k<stardata->common.n_events; k++)
            {
                Eprint("EVENT STACK IN t=%g %d : %d/%d %p : event[%d] = %p\n",
                       stardata->model.time,
                       stardata->model.model_number,
                       k,
                       stardata->common.n_events,
                       stardata->common.events,
                       k,
                       stardata->common.events[k]);
            }
        }

        stardata->common.had_event =
            Boolean_(stardata->common.n_events > 0);
    
        while(stardata->common.n_events > 0)
        {
            trigger_event(stardata,
                          stardata->common.events[0]);
        }
    
        if(vb)
        {
            if(stardata->common.n_events)
            {
                for(k=0; k<stardata->common.n_events; k++)
                {
                    Eprint("EVENT STACK OUT t=%g %d : %d/%d %p : event[%d] = %p\n",
                           stardata->model.time,
                           stardata->model.model_number,
                           k,
                           stardata->common.n_events,
                           stardata->common.events,
                           k,
                           stardata->common.events[k]);
                }
            }
            else
            {
                //Eprint("EVENT STACK OUT empty\n");
            }
        }
    }
    else
    {
        Eprint("Events cannot be caught on intermediate steps\n");
        erase_events(stardata);
    }
    return;
}

