
#include "../binary_c.h"

#ifdef DISCS

/*
 * Remove all discs of a given type from an object
 */

void remove_discs(Disc_type type,
                  void * object)
{
    if(type == DISC_CIRCUMSTELLAR || type == DISC_ANY)
    {
        struct star_t * star = object;
        while(star->ndiscs>0)
        {
            remove_disc(type,object,DISC_OUTER_EDGE,DISC_REMOVE_ALL);
        }
    }
    else if(type == DISC_CIRCUMBINARY || type == DISC_ANY)
    {
        struct stardata_t * stardata = object;
        while(stardata->common.ndiscs>0)
        {
            remove_disc(type,object,DISC_OUTER_EDGE,DISC_REMOVE_ALL);
        }
    }
    else
    {
        Exit_binary_c_no_stardata(
            BINARY_C_UNKNOWN_DISC_TYPE,
            "Disc type %d unknown",
            type);
    }
}



#endif//DISCS
