#include "../binary_c.h"

#ifdef DISCS

#include "disc_constraints.h"

void disc_set_disc_initial_guess(struct disc_t * const disc,
                                 const int iguess,
                                 const int n,
                                 const disc_parameter * const parameter_types,
                                 double initial_guesses[DISC_SOLVER_NINITIAL_GUESSES][n])
{
    /*
     * Set intitial guess number iguess into the disc
     */
    int i;
    double unknown;
    Discdebug(1,
              "Set initial guess : solver = %s :: ",
              Solver_string(disc->solver));
    for(i=0;i<n;i++)
    {
        Disc_parameter(disc,parameter_types[i]) = initial_guesses[iguess][i];
        Discdebug_plain(1,
                        " %s = %g %s",
                        Disc_parameter_string(parameter_types[i]),
                        Disc_parameter(disc,parameter_types[i]),
                        ((i==n-1) ? "" : ","));
    }
    Discdebug_plain(1,"\n");
}

#endif // DISCS
