#pragma once
#ifndef DISC_MACROS_H
#define DISC_MACROS_H

/*
 * Macros related to the binary_c treatment of discs
 */

/* disc types (unsigned int) */
#define DISC_ANY -1
#define DISC_NONE 0
#define DISC_CIRCUMSTELLAR 1
#define DISC_CIRCUMBINARY 2

/* disc positions */
#define DISC_INNER_EDGE -1
#define DISC_OUTER_EDGE -2


#define BISECT_M 1
#define BISECT_J 2
#define BISECT_F 3

#define CONVERGENCE_FAILED 0
#define CONVERGENCE_SUCCEEDED 1
#define CONVERGENCE_FLUX_NEGATIVE 2


/*
 * Reasons for disc removal
 */
#define DISC_REMOVE_FORMED_RING 0
#define DISC_REMOVE_REPLACE 1
#define DISC_REMOVE_EVAPORATE 2
#define DISC_REMOVE_ALL 3


#define DISC_SOLVER_ORDERED_LIST                \
    GSL_MULTIROOT_FSOLVER_HYBRIDS,              \
        GSL_MULTIROOT_FSOLVER_HYBRID,           \
        DISC_SOLVER_BISECTION

#define DISC_SOLVER_NINITIAL_GUESSES 5
#define DISC_SOLVER_NINITIAL_GUESSES 5
#define DISC_SOLVER_NSOLVERS 3
#define DISC_SOLVER_NONE 0
#define DISC_SOLVER_BISECTION -1


/*
 * Circumbinary disc eccentricity pumping algorithms
 */
#define CBDISC_ECCENTRICITY_PUMPING_NONE 0 
#define CBDISC_ECCENTRICITY_PUMPING_DERMINE 1

/*
 * Circumbinary disc from commom envelope 
 * angular momentum selectors
 */
#define CBDISC_ANGMOM_FROM_MOMENTS_OF_INERTIA -1
#define CBDISC_ANGMOM_FROM_COMENV_SPECIFIC_ANGMOM -2
#define CBDISC_ANGMOM_FROM_POSTCE_L2 -3
#define CBDISC_ANGMOM_FROM_PRECE_RADIUS -4

/*
 * Circumbinary disc angular momentum selectors
 */
#define CBDISC_ANGMOM_FROM_WIND_L2 -1

/*
 * Circumbinary viscous accretion which star gains mass method 
 */
#define CBDISC_MASS_LOSS_INNER_VISCOUS_ACCRETION_METHOD_YOUNG_CLARKE_2015 0
#define CBDISC_MASS_LOSS_INNER_VISCOUS_ACCRETION_METHOD_GEROSA_2015 1
#define CBDISC_MASS_LOSS_INNER_VISCOUS_ACCRETION_METHOD_EQUAL 2
#define CBDISC_MASS_LOSS_INNER_VISCOUS_ACCRETION_METHOD_NONE 3

/*
 * Minimum disc mass (in Msun)
 */
#define MINIMUM_DISC_MASS 1e-6

/* disc mass/angmom/ecc loss/gain mechanisms */
#define DISC_LOSS_GLOBAL 0
#define DISC_LOSS_INNER_VISCOUS 1
#define DISC_LOSS_INNER_L2_CROSSING 2
#define DISC_LOSS_FUV 3
#define DISC_LOSS_XRAY 4
#define DISC_LOSS_BINARY_TORQUE 5
#define DISC_LOSS_ISM 6
#define DISC_LOSS_RESONANCES 7
#define DISC_LOSS_NEGATIVE_FLUX 8
#define DISC_LOSS_INNER_EDGE 9
#define DISC_LOSS_OUTER_EDGE 10
#define DISC_LOSS_N 11

#define DISC_LOSS_STRINGS                       \
    "Global",                                   \
        "Inner Viscous",                        \
        "Inner L2 Crossing",                    \
        "FUV",                                  \
        "X-ray",                                \
        "Binary torque",                        \
        "ISM ram stripping (global)",           \
        "Resonances",                           \
        "Negative flux",                        \
        "Inner edge",                           \
        "Outer edge"

#define DISC_ZONES_FAILED 0
#define DISC_ZONES_OK 1
#define DISC_ZONES_NEW_ZONE_LIST_RIN_EQUALS_ROUT 2
#define DISC_ZONES_NO_ZONES 3
#define DISC_ZONES_RIN_EXCEEDS_ROUT 4

#define DISC_LOSS_ISM_GLOBAL 0
#define DISC_LOSS_ISM_OUTER_EDGE 1


/************************************************************/
/*
 * Disc logging caller functions
 */
#define DISC_LOG_EVOLVE_DISC_STRUCTURE 0
#define DISC_LOG_EVOLVE_DISC_STRUCTURE2 1
#define DISC_LOG_EVERY_TIMESTEP 2



/*
 * File pointers used to do logging
 */
#define Disc_log_filepointer (stardata->tmpstore->disc_logfile)
#define Disc_log_filepointer2d (stardata->tmpstore->disc_logfile2d)

/*
 * Macro that returns true if we want
 * to reopen log files
 */
#define Disc_can_reopen_log (                   \
        ((stardata->preferences->disc_log) > 0) \
        ? TRUE : FALSE                          \
        )
#define Disc_can_reopen_log2d (                         \
        ((stardata->preferences->disc_log2d) > 0)       \
        ? TRUE : FALSE                                  \
        )
/*
 * Macros that returns TRUE if we want to log
 */
#define Disc_can_log (                                          \
        (stardata->preferences->disc_log != DISC_LOG_LEVEL_NONE \
         &&                                                     \
         (stardata->tmpstore->disc_logfilecount==0 ||           \
          Disc_can_reopen_log))                                 \
        ? TRUE : FALSE                                          \
        )
#define Disc_can_log2d (                                                \
        (stardata->preferences->disc_log2d != DISC_LOG_LEVEL_NONE       \
         &&                                                             \
         (stardata->tmpstore->disc_logfilecount2d==0 ||                 \
          Disc_can_reopen_log2d))                                       \
        ? TRUE : FALSE                                                  \
        )

/************************************************************/


#define DISC_EDGE_STRIPPING_IN_CONVERGENCE_STEP 0
#define DISC_EDGE_STRIPPING_AFTER_CONVERGENCE_STEP 1
#define DISC_EDGE_STRIPPING_BEFORE_CONVERGENCE_STEP 2


/*
 * Space for a new disc
 */
#define New_disc Malloc(sizeof(struct disc_t))


/*
 * Disc timestep limiters
 */
#define DISC_TIMESTEP_LIMIT_M 0
#define DISC_TIMESTEP_LIMIT_J 1
#define DISC_TIMESTEP_LIMIT_F 2
#define DISC_TIMESTEP_LIMIT_MIN 3
#define DISC_TIMESTEP_LIMIT_MAX 4
#define DISC_TIMESTEP_LIMIT_TOO_FAST 5

/*
 * disc log levels
 */
#define DISC_LOG_LEVEL_NONE 0
#define DISC_LOG_LEVEL_NORMAL 1
#define DISC_LOG_LEVEL_SUBTIMESTEP 2
#define DISC_LOG_LEVEL_NORMAL_FIRST_DISC_ONLY -1
#define DISC_LOG_LEVEL_SUBTIMESTEP_FIRST_DISC_ONLY -2


/*
 * Macros to define the stripping timescale options
 */
#define DISC_STRIPPING_TIMESCALE_INSTANT 0
#define DISC_STRIPPING_TIMESCALE_INFINITE 1
#define DISC_STRIPPING_TIMESCALE_VISCOUS 2
#define DISC_STRIPPING_TIMESCALE_ORBIT 3


/*
 * Macro to determine whether "const disc" should be used
 * in function calls, or "disc". If we're using MEMOIZE,
 * disc can be changed (because it contains disc->memo which
 * is writable) so we don't want the const.
 */
#ifdef MEMOIZE
#define DISC_CONST 
#else
#define DISC_CONST const
#endif

#endif // DISC_MACROS_H
