#include "../binary_c.h"
#ifdef DISCS

void disc_edge_stripping(struct stardata_t * const stardata,
                         struct disc_t * const newdisc,
                         struct disc_t * const olddisc,
                         const struct binary_system_t * const binary)
{
    /*
     * By default, apply no correction to the angular momentum flux
     */
    newdisc->F_stripping_correction = 0.0;
    
    /*
     * Perform outer edge mass loss
     */
    if(stardata->preferences->cbdisc_outer_edge_stripping==TRUE)
    {
        disc_outer_edge_mass_loss(stardata,newdisc,olddisc,binary);
               
        if(Is_not_zero(olddisc->Revap_out) &&
           !Fequal(olddisc->Revap_out,newdisc->Revap_out))
        {
            if(newdisc->Revap_out < olddisc->Revap_out)
            {
                /*
                 * New material is caught up in the stripping which should
                 * be removed. This material is now gone, along with its 
                 * angular momentum, and there is no adjustment to the 
                 * angular momentum flux.
                 */
            }
            else
            {
                /*
                 * newdisc->Revap_out > olddisc->Revap_out
                 *
                 * The disc expands outwards to fill the gap. 
                 *
                 * No mass is lost.
                 *
                 * Suppress viscous inflow which would have flowed 
                 * through this inner edge, and adjust the angular momentum
                 * flux.
                 */
                newdisc->F_stripping_correction +=
                    1.0/(olddisc->Rout - olddisc->Rin) * 
                    newdisc->loss[DISC_LOSS_OUTER_EDGE].mdot
                    / olddisc->M *
                    disc_total_angular_momentum_flux_correction(olddisc,binary);
                newdisc->loss[DISC_LOSS_OUTER_EDGE].mdot = 0.0;
                newdisc->loss[DISC_LOSS_OUTER_EDGE].jdot = 0.0;
                newdisc->loss[DISC_LOSS_OUTER_EDGE].edot = 0.0;
            }
        }

#ifdef __DO_NOT_BUILD
        if(0)
            printf("REVAP OUT was %g is %g : %s ... mdot = %g, jdot = %g, Fcorr = %g\n",
                   olddisc->Revap_out,
                   newdisc->Revap_out,
                   
               (
                   Fequal(newdisc->Revap_out, olddisc->Revap_out) ? "=" :
                   newdisc->Revap_out < olddisc->Revap_out ? "<" :
                   ">"
                   ),
               newdisc->loss[DISC_LOSS_OUTER_EDGE].mdot * YEAR_LENGTH_IN_SECONDS / M_SUN,
               newdisc->loss[DISC_LOSS_OUTER_EDGE].jdot,
               newdisc->F_stripping_correction
            );
#endif        
    }
    
    /*
     * Perform inner edge mass loss
     */
    if(stardata->preferences->cbdisc_inner_edge_stripping==TRUE)
    {
        disc_inner_edge_mass_loss(stardata,newdisc,olddisc,binary);

#if 0
        printf("REVAP was %g %s now %g %s\n",
               Solar(olddisc->Revap_in,R),
               Solar(newdisc->Revap_in,R));
#endif   
        if(Is_not_zero(olddisc->Revap_in)
           &&
           !Fequal(olddisc->Revap_in,newdisc->Revap_in))
        {
            if(newdisc->Revap_in > olddisc->Revap_in)
            {
                /*
                 * New material is caught up in the stripping which should
                 * be removed. This material is now gone, along with its 
                 * angular momentum, and there is no adjustment to the 
                 * angular momentum flux.
                 */
            }
            else
            {
                printf("Disc moves inwards\n");
                
                /*
                 * Revap_in moves inwards
                 *
                 * The disc can expand inwards to fill the gap, 
                 * no extra mass is lost.
                 *
                 * Suppress viscous inflow which would have flowed 
                 * through this inner edge, and adjust the angular momentum
                 * flux.
                 */
                newdisc->suppress_viscous_inflow = TRUE;
                newdisc->F_stripping_correction -=
                    1.0/(olddisc->Rout - olddisc->Rin) * 
                    newdisc->loss[DISC_LOSS_INNER_EDGE].mdot
                    / olddisc->M *
                    disc_total_angular_momentum_flux_correction(olddisc,binary);
                newdisc->loss[DISC_LOSS_INNER_EDGE].mdot = 0.0;
                newdisc->loss[DISC_LOSS_INNER_EDGE].jdot = 0.0;
                newdisc->loss[DISC_LOSS_INNER_EDGE].edot = 0.0;
            }
        }
    }

    if(0 &&
       stardata->star[0].stellar_type == 6 &&
       stardata->star[0].mass - stardata->star[0].core_mass < 0.1 &&
       Is_zero(olddisc->Revap_in) &&
       Is_not_zero(newdisc->Revap_in))
    {
        Exit_binary_c(2,"temp exit");
    }
}


#endif
