#include "../binary_c.h"

#ifdef DISCS

void disc_edge_loss_angular_momentum_flux(struct disc_t * const disc,
                                          const struct binary_system_t * const binary)
{

    /*
     * Calculate corrections to the angular momentum flux
     * caused because of edge stripping.
     *
     * Note that both the mdot terms are negative.
     */
    if(Disc_is_disc(disc) &&
       !Fequal(disc->Rin, disc->Rout))
    {
        disc->F_stripping_correction =
            1.0/(disc->Rout - disc->Rin) * 
            (disc->loss[DISC_LOSS_OUTER_EDGE].mdot - 
             disc->loss[DISC_LOSS_INNER_EDGE].mdot) 
            / disc->M *
            disc_total_angular_momentum_flux_correction(disc,binary);
    }
    else
    {
        disc->F_stripping_correction = 0.0;
    }
}


#endif //DISCS
