#include "../binary_c.h"

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif
#ifndef __USE_GNU
#define __USE_GNU
#endif

#include <ucontext.h>
#include <execinfo.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

/* Obtain a backtrace and print it to stdout. */

void Print_trace(void)
{
#ifdef BACKTRACE
    print_trace();
#endif
}

#ifdef BACKTRACE
#include <execinfo.h>

#ifdef __HAVE_LIBBACKTRACE__
#include <backtrace.h>
#include <backtrace-supported.h>
#endif // __HAVE_LIBBACKTRACE__

/* This structure mirrors the one found in /usr/include/asm/ucontext.h */
typedef struct _sig_ucontext {
    unsigned long     uc_flags;
    struct ucontext   *uc_link;
    stack_t           uc_stack;
    struct sigcontext uc_mcontext;
    sigset_t          uc_sigmask;
} sig_ucontext_t;
struct bt_ctx {
	struct backtrace_state *state;
	int error;
};

#ifdef __HAVE_LIBBACKTRACE__
#include "libbacktrace_functions.h"
#endif // __HAVE_LIBBACKTRACE__


void print_trace (void)
{
#if BACKTRACE_METHOD == BACKTRACE_METHOD_LIBBACKTRACE
    /*
     * libbacktrace to show the trace.
     * This is the preferred method.
     */
    printf("backtrace with libbacktrace\n");
    struct backtrace_state *state = backtrace_create_state (
        "binary_c",
        BACKTRACE_SUPPORTS_THREADS, error_callback, NULL);
    bt(state);

#elif BACKTRACE_METHOD == BACKTRACE_METHOD_GNU
    /*
     * Otherwise use GNU's backtrace_symbols, sending
     * output to stderr in case of failure.
     */
    printf("backtrace with gnu\n");
#define TRACELENGTH 20

    void *array[TRACELENGTH];
    size_t size = backtrace (array, TRACELENGTH);
    backtrace_symbols_fd(array,size,STDERR_FILENO);

#elif BACKTRACE_METHOD == BACKTRACE_METHOD_GNU_BUFFER
    printf("backtrace with gnu buffer\n");
    /*
     * This puts the strings in a buffer.
     * This is bad, because it requires malloc which
     * may be broken.
     */
#define TRACELENGTH 20
    char **strings;
    void *array[TRACELENGTH];
    size_t size = backtrace (array, TRACELENGTH);
    strings = backtrace_symbols (array, size);
    fprintf(BACKTRACE_GNU_BUFFER_STREAM,"Obtained %zd stack frames.\n", size);
    int i;
    for (i = 0; i < size; i++)
    {
        fprintf(BACKTRACE_GNU_BUFFER_STREAM,"Frame %d\n",i);
        fprintf(BACKTRACE_GNU_BUFFER_STREAM,"   >  %s \n", strings[i]);
        fflush(BACKTRACE_GNU_BUFFER_STREAM);
    }
    free(strings);

#elif BACKTRACE_METHOD == BACKTRACE_METHOD_LOCAL
    /*
     * Use local function, may be buggy
     */
#define TRACELENGTH 20
    printf("backtrace with local\n");
    char **strings;
    void *array[TRACELENGTH];
    size_t size = backtrace (array, TRACELENGTH);
    backtrace_symbols_local(array,size);
#endif

    

}

#endif //BACKTRACE
     
