#!/bin/bash

# make data objects for common envelope evolution with binary_c
# http://gareus.org/wiki/embedding_resources_in_executables

: ${CC:="gcc"}
: ${OBJCOPY_OPTS:="-I binary -B i386:x86-64 -O elf64-x86-64"}

# large 3D polytrope table
HFILE=common_envelope_polytrope_3d.h
TMPFILE=common_envelope_polytrope_3d.dat
OBJFILE=common_envelope_polytrope_3d.o

if [ $HFILE -nt $OBJFILE ] ; then
    
    $CC ../../double2bin.c -o ./double2bin

    cat $HFILE | tr , ' ' | sed s/\\\\// | grep -v define |grep -v \* | ./double2bin > $TMPFILE

    # The common-envelope table can be read-only
    OPTS="--rename-section .data=.rodata,alloc,load,readonly,data,contents "

    objcopy $OBJCOPY_OPTS $OPTS $TMPFILE $OBJFILE
    # ld -r -b binary -o $OBJFILE $TMPFILE

    rm $TMPFILE
    rm ./double2bin
fi

echo $OBJFILE
