#include "../binary_c.h"

/*
 * Function to calculate the common-envelope
 * structure parameter, lambda.
 *
 *
 * INPUT:
 *
 * convfrac = menv_conv / (M-Mc)
 *            is the fraction of the envelope that is convective
 *
 *
 * 
 */


Constant_function double common_envelope_lambda(const double m,
                                                const double mc,
                                                const double lum,
                                                const double rad,
                                                const double rzams,
                                                const double rc,
                                                const double convfrac,
                                                const int stellar_type,
#ifdef NUCSYN
                                                Abundance * const Xenv,
#endif
                                                struct stardata_t * RESTRICT const stardata)
{
    /* final lambda calculation result */
    double result;

#ifdef LOG_CE_PARAMETERS
    double lambda_pre_ion=0.0;
#endif
/*
 * A function to estimate lambda for common-envelope.
 */

    Dprint("Lambda CE estimation: stellar_type=%d m=%g convfrac=%g lum=%g rad=%g rzams=%g\n",
           stellar_type,m,convfrac,lum,rad,rzams
        );

    /* perhaps use command-line specified lambda_ce */
    if(stardata->preferences->lambda_ce>0.0)
    {
        result=stardata->preferences->lambda_ce;
        Dprint("Choose lambda_ce from the command line (is %g)\n",result);
    }
    else
    {
        if(Fequal(stardata->preferences->lambda_ce,
                  LAMBDA_CE_DEWI_TAURIS))
        {
            result = common_envelope_dewi_tauris(convfrac,
                                                 lum,
                                                 m,
                                                 rzams,
                                                 rad,
                                                 stellar_type,
                                                 stardata);
        }
        else if(Fequal(stardata->preferences->lambda_ce,
                       LAMBDA_CE_WANG_2016))
        {
            result = common_envelope_wang2016(m,
                                              rad,
                                              stellar_type,
                                              stardata);
        }
#ifdef COMENV_POLYTROPES
        else if(Fequal(stardata->preferences->lambda_ce,
                       LAMBDA_CE_POLYTROPE))
        {

            result = common_envelope_polytrope(m,mc,rad,rc,
#ifdef NUCSYN
                                               Xenv,
#endif//NUCSYN 
                                               stardata);

        }
#endif // COMENV_POLYTROPES
        else
        {
            result = 0.0;
            Exit_binary_c(BINARY_C_ALGORITHM_BRANCH_FAILURE,
                          "Common envelope prescription %g has no coded counterpart.\n",
                          stardata->preferences->lambda_ce);
        }
    }

    result = Max(LAMBDA_CE_MIN,result);

    Dprint("CELAMF %g (lambda_ion=%g)\n",
           result,
           stardata->preferences->lambda_ionisation
        );

#ifdef LOG_CE_PARAMETERS
    {
        char s[255]=sprintf "Common envelope : lambda=%g (pre-ion=%g)\n",
            result,lambda_pre_ion;
        output_string_to_logfile(stardata,s);
    }
#endif

    return(result);
}



