#pragma once
#ifndef COMMON_ENVELOPE_H
#define COMMON_ENVELOPE_H

#include "../binary_c.h"

#define ACCURACY 1.0E-6

#define HEADER "MIXING (COMENV) "

#define CGS_ENERGY (-M_SUN*M_SUN*GRAVITATIONAL_CONSTANT/R_SUN)

#define TOTAL_YIELD (stardata->star[0].Xyield[kk]+stardata->star[1].Xyield[kk])

#if (defined(MIXDEBUG) && (!defined(NUCSYN)))
#undef MIXDEBUG
#endif

#ifndef MIXDEBUG
#define MIXDEBUG 0
#else
#undef MIXDEBUG
#define MIXDEBUG 1
#endif

#define LARGE_LAMBDA LARGE_FLOAT


#define DENY_EVENTS TRUE
#define ALLOW_EVENTS FALSE

/*
 * Use logarithms when finding an envelope mass?
 */
#define BISECTOR_COMENV_DM_USELOG FALSE


/* 
 * conditions for using Nelemans common envelope prescription:
 * 1) companion is unevolved (MS)
 * 2) q=M2/M1>0.2
 * 3) This is the nth common envelope phase where n < preferences->nelemans_n_comenvs
 */
/* relax the MS condition */
#ifdef COUNT_COMENVS
#define USE_NELEMANS							\
    (((m1init/m2init)>stardata->preferences->nelemans_minq)&&           \
     (stardata->model.comenv_count<=stardata->preferences->nelemans_n_comenvs))
#else
/* no count available: just use Nelemans' prescription if q is appropriate */
#define USE_NELEMANS ((m1init/m2init)>stardata->preferences->nelemans_minq)
#endif

#define UNBOUND (stardata->common.orbit.eccentricity > 1.0)
#define RETURN_IF_UNBOUND if(UNBOUND)    goto end_section; 

#ifdef NUCSYN_MERGER_DREDGEUP
#define COMENV_ABUND_ARRAYS common_envelope_abundance, merger_dredgeup_abundance, new_stellar_envelope_abundance
#else
#define COMENV_ABUND_ARRAYS common_envelope_abundance, new_stellar_envelope_abundance
#endif


#define Mprint(...) if(MIXDEBUG)                                        \
        mixdebug_fprintf(stardata,__FILE__,__LINE__,__VA_ARGS__);

#if defined MIXDEBUG && defined NUCSYN


#define _Abundance_list3(A) A[XH1],A[XHe4],A[XC12]
#define _Abundance_list5(A) A[XH1],A[XHe4],A[XC12],A[XN14],A[XO16]
#define _Abundance_list5Fe(A) A[XH1],A[XHe4],A[XC12],A[XO16],A[XFe56]
#define _Abundance_list6(A) A[XH1],A[XHe4],A[XC12],A[XC13],A[XN14],A[XO16]
#define _Abundance_list7(A) _Abundance_list6(A),Carbon_oxygen_ratio(A)
#define _Abundance_list8(A) _Abundance_list7(A),nucsyn_totalX(stardata,A,0,ISOTOPE_ARRAY_SIZE)


#define Mix_debug_in_out(A) {                                              \
        Mprint("Comenv %s - total mass %g (+yields %g)\n",              \
               A,                                                       \
               donor->mass+accretor->mass,msum);                        \
        Mprint("Star 1 m=%g (m0=%g) mc=%g menv=%g type=%d R=%g Rc=%g\n", \
               donor->mass,                                             \
               donor->phase_start_mass,                                 \
               donor->core_mass,                                        \
               donor->mass-donor->core_mass,                            \
               donor->stellar_type,                                     \
               r1,                                                      \
               rc1);                                                    \
        Mprint("XH1=%12.12e XHe4=%g XC12=%g XC13=%g XN14=%g XO16=%g (C/O=%g) Xtot=%g\n", \
               _Abundance_list8(stardata->star[donor->starnum].Xenv));           \
        Mprint("Star 2 m=%g (m0=%g) mc=%g menv=%g type=%d R=%g Rc=%g\n", \
               accretor->mass,                                          \
               accretor->phase_start_mass,                              \
               accretor->core_mass,                                     \
               accretor->mass-accretor->core_mass,                      \
               accretor->stellar_type,                                  \
               r2,                                                      \
               rc2);                                                    \
        Mprint("XH1=%g XHe4=%g XC12=%g XC13=%g XN14=%g XO16=%g (C/O=%g) Xtot=%g\n", \
               _Abundance_list8(stardata->star[donor->starnum].Xenv));           \
        fflush(stdout);                                                 \
    }


#else //MIXDEBUG

#define Mix_debug_in_out(A) /**/


#endif //MIXDEBUG




#define ACCRETE_ARGS                            \
    stardata,                                   \
	donor->starnum,                         \
	accretor->starnum,                      \
	GB,					\
	tscls1,					\
	tscls2,					\
	lums,					\
	&donor->mass,                           \
	&accretor->mass,                        \
	&donor->phase_start_mass,               \
	&accretor->phase_start_mass,            \
	&donor->age,                            \
	&accretor->age,                         \
	&l1,					\
	&l2,					\
	&r1,					\
	&r2,					\
	&menv,					\
	&renv,					\
	&tm1,					\
	&tm2,					\
	&donor->core_mass,                      \
	&accretor->core_mass,                   \
	&rc1,					\
	&rc2,					\
	&k21,					\
	&k22,					\
	&tn,					\
	common_envelope_mass,			\
	&donor->stellar_type,                   \
	&accretor->stellar_type




#define MDEBUG_PRETTY_STARS_IN                                          \
    Mprint("Trying to dilute to comenv: H1_1=%g * %g H1_2=%g * %g -> H1_env=%g\n", \
	   m1init-effective_mc1,stardata->star[donor->starnum].Xenv[XH1], \
           m2init-effective_mc2,stardata->star[accretor->starnum].Xenv[XH1], \
           common_envelope_abundance[XH1]);				\
    Mprint("Effective cores:\n");                                       \
    Mprint("Star 1 m=%g (m0=%g) mc'=%g menv=%g type=%d\n",              \
           donor->mass,                                                 \
           donor->phase_start_mass,                                     \
           effective_mc1,                                               \
           donor->mass-effective_mc1,                                   \
           donor->stellar_type);                                        \
    Mprint("Star 2 m=%g (m0=%g) mc'=%g menv=%g type=%d\n",              \
           accretor->mass,                                              \
           accretor->phase_start_mass,                                  \
           effective_mc2,                                               \
           accretor->mass-effective_mc2,                                \
           accretor->stellar_type);                                     \
    Mprint("total mass at this stage %g\n",donor->mass+accretor->mass); \
    Mprint("/---------------------------\\\n");                         \
    Mprint("|         %3.3e         |\n",common_envelope_mass);         \
    Mprint("|                           |\n");                          \
    Mprint("|                    <-     |\n");                          \
    Mprint("|                     |     |\n");                          \
    Mprint("|  /-------\\     /-------\\  |\n");			\
    Mprint("| /%3.3e\\   /%3.3e\\ |\n",effective_mc1,effective_mc2);    \
    Mprint("| \\  %4d   /   \\  %4d   / |\n",donor->stellar_type,accretor->stellar_type); \
    Mprint("|  \\-------/     \\-------/  |\n");			\
    Mprint("|      |                    |\n");                          \
    Mprint("|      ->                   |\n");                          \
    Mprint("|                           |\n");                          \
    Mprint("\\---------------------------/\n");                         \
									\
    Mprint("Common envelope mass %g (mass in effective cores = %g, total = %g)\n",common_envelope_mass, \
           effective_mc1+effective_mc2,                                 \
           effective_mc1+effective_mc2+common_envelope_mass);           \
    Mprint("Common envelope abundances : XH1=%12.12e XHe4=%g XC12=%g XC13=%g XN14=%g XO16=%g C/O=%g Total=%g\n", \
           _Abundance_list8(common_envelope_abundance));

#define MDEBUG_PRETTY_MERGER                                            \
    Mprint("/ - - - - - - - - - - - - - - - \\\n");                     \
    Mprint("| To ISM : %3.3e            |\n",dm);			\
    Mprint("  /---------------------------\\\n");			\
    Mprint("| |Envelope %3.3e (C%2.2f) | |\n",donor->mass-donor->core_mass,dM2/(donor->mass-donor->core_mass+TINY)); \
    Mprint("  |Type     %4d              |\n",stellar_type);            \
    Mprint("| |       /---------\\         | |\n");			\
    Mprint("  |       |Core     |         |\n");			\
    Mprint("| |       |%3.3e|         | |\n",donor->core_mass);         \
    Mprint("  |       \\---------/         |\n");			\
    Mprint("| |                           | |\n");			\
    Mprint("  \\---------------------------/\n");			\
    Mprint("\\ - - - - - - - - - - - - - - - /\n");			\
    Mprint("New envelope for merged cores: %12.12g from common envelope, %12.12g from stars\n", \
           dM1,dM2-dM1);

#define MDEBUG_PRETTY_NOT_MERGER                                        \
    Mprint(" - - - - - - - - - - - - - -  \n");                         \
    Mprint("| TO ISM: %3.3e         |\n",common_envelope_mass);         \
    Mprint("                             \n");                          \
    Mprint("|                    <-     |\n");                          \
    Mprint("                      |      \n");                          \
    Mprint("|  /-------\\     /-------\\  |\n");			\
    Mprint("  /%3.3e\\   /%3.3e\\  \n",donor->mass,accretor->mass);     \
    Mprint("  |%3.3e|   |%3.3e|  \n",effective_mc1,effective_mc2);      \
    Mprint("| \\  %4d   /   \\  %4d   / |\n",donor->stellar_type,accretor->stellar_type); \
    Mprint("   \\-------/     \\-------/   \n");			\
    Mprint("|      |                    |\n");                          \
    Mprint("       ->                    \n");                          \
    Mprint("|                           |\n");                          \
    Mprint(" - - - - - - - - - - - - - - \n");  



#if defined MIXDEBUG && defined NUCSYN

#define MDEBUG_CALC_MSUM msum=0.0;				\
    Isotope_loop(kk)                                            \
    {								\
        msum+=TOTAL_YIELD;					\
    }								\
    msum+=stardata->star[0].mass+stardata->star[1].mass;
#else
#define MDEBUG_CALC_MSUM /**/
#endif

/*
 * Note that this is called twice but with different radii
 * for the secondary : in the case of a main sequence star, R2=r2
 * but for stars with cores R2=rc2
 */

#define CORE_RLOF(R2) (More_or_equal(rc1/rl1,(R2)/rl2))

#define CHECK_FOR_CORE_RLOF(R2)                                         \
    stardata->model.coalesce = FALSE;                                   \
    Roche_separation = 0.0;                                             \
    if(CORE_RLOF(R2))                                                   \
    {                                                                   \
        if(rc1 > rl1 || Is_zero(final_separation))                      \
        {                                                               \
	    stardata->model.coalesce = 1;                               \
	    Roche_separation = Is_zero(final_separation) ? rc1 : final_separation * rc1/rl1; \
            Dprint("SETSEPL1 %g : sepF = %g rc1 = %g rl1 = %g\n",Roche_separation,final_separation,rc1,rl1); \
        }                                                               \
    }                                                                   \
    else if( (R2) > rl2 || Is_zero(final_separation))                   \
    {                                                                   \
	stardata->model.coalesce = 2;                                   \
	Roche_separation = Is_zero(final_separation) ? (R2) : final_separation * (R2)/rl2; \
        Dprint("SETSEPL2 %g\n",Roche_separation);                       \
    }                                                                   \
    Dprint("Merger? %u\n",stardata->model.coalesce);                    \
    if(stardata->model.coalesce>0)                                      \
    {                                                                   \
        Append_logstring(LOG_COMENV_PRE,                                \
                         "Merge%u [rc1=%g%crl1=%g] [R2=%g%crl2=%g] ",   \
                         stardata->model.coalesce,                      \
                         rc1,                                           \
                         (stardata->model.coalesce==1 ? '>' : '<'),     \
                         rl1,                                           \
                         R2,                                            \
                         (stardata->model.coalesce==2 ? '>' : '<'),     \
                         rl2                                            \
            );                                                          \
        stardata->model.coalesce=TRUE;                                  \
        Dprint("cores have merged\n");                                  \
    }                                                                   \
    Append_logstring(LOG_COMENV_PRE,                                    \
                     "sepF=%g 1:Rc=%g~RL=%g 2:Rc=%g~RL=%g ",            \
                     final_separation,rc1,rl1,r2,rl2);


#define AGE_HELIUM_STAR_OR_CORE                                         \
    if((donor->stellar_type)<=FIRST_GIANT_BRANCH)                       \
    {                                                                   \
        fage1 = 0.0;                                                    \
        if(accretor->stellar_type==COWD)                                \
        {                                                               \
            fage1=accretor->mass/(accretor->mass+donor->core_mass);     \
        }                                                               \
    }                                                                   \
    else if((donor->stellar_type)>=TPAGB)                               \
    {                                                                   \
        fage1 = 1.0;                                                    \
    }                                                                   \
    else                                                                \
    {                                                                   \
        fage1 = ((donor->age) - tscls1[2])/(tscls1[13] - tscls1[2]);	\
    }                                                                   \
									\
    if(((accretor->stellar_type)<=FIRST_GIANT_BRANCH)||                 \
       ((accretor->stellar_type)==HeWD))                                \
    {                                                                   \
        fage2 = 0.0;                                                    \
    }                                                                   \
    else if((accretor->stellar_type)==HeMS)                             \
    {                                                                   \
        fage2 = (accretor->age)/tm2;					\
        mc22 = (accretor->mass);                                        \
    }                                                                   \
    else if((accretor->stellar_type)>=TPAGB)                            \
    {                                                                   \
        fage2 = 1.0;                                                    \
    }                                                                   \
    else                                                                \
    {                                                                   \
        fage2 = ((accretor->age) - tscls2[2])/(tscls2[13] - tscls2[2]); \
    }


/*
 * Calc-lum-and-evol-time and stellar_structure calls in macro form
 */		


#define TIMESCALESmerge                                         \
    stellar_timescales(stellar_type,                            \
                       donor->phase_start_mass,                 \
                       donor->mass,                             \
                       &tm1,                                    \
                       &tn,                                     \
                       tscls1,                                  \
                       lums,                                    \
                       GB,                                      \
                       stardata,                                \
                       &(stardata->star[donor->starnum]));

#define TIMESCALESmerge_t2                                      \
    stellar_timescales(stellar_type,                            \
                       donor->mass,                             \
                       donor->mass,                             \
                       &tm2,                                    \
                       &tn,                                     \
                       tscls2,                                  \
                       lums,                                    \
                       GB,                                      \
                       stardata,                                \
                       &(stardata->star[donor->starnum]));

#define TIMESCALES1                                             \
    stellar_timescales(donor->stellar_type,                     \
                       donor->phase_start_mass,                 \
                       donor->mass,                             \
                       &tm1,                                    \
                       &tn,                                     \
                       tscls1,                                  \
                       lums,                                    \
                       GB,                                      \
                       stardata,                                \
                       &(stardata->star[donor->starnum]));


#define STELLAR_STRUCTURE1                                              \
    stellar_structure_longcall(&donor->phase_start_mass,                \
                               &donor->phase_start_core_mass,           \
                               &donor->age,                             \
                               &donor->mass,                            \
                               &tm1,                                    \
                               &tn,                                     \
                               tscls1,                                  \
                               lums,                                    \
                               GB,                                      \
                               &r1,                                     \
                               &l1,                                     \
                               &donor->stellar_type,                    \
                               &donor->core_mass,                       \
                               &donor->CO_core_mass,                    \
                               &donor->GB_core_mass,                    \
                               &donor->max_MS_core_mass,                \
                               &rc1,                                    \
                               &menv,                                   \
                               &renv,                                   \
                               &k21,                                    \
                               &donor->time_first_pulse,                \
                               &donor->num_thermal_pulses,              \
                               &donor->time_prev_pulse,                 \
                               &donor->prev_tagb,                       \
                               &donor->menv_1tp,                        \
                               &donor->mc_1tp,                          \
                               &donor->core_mass_no_3dup,               \
                               &donor->interpulse_period,               \
                               &donor->time_next_pulse,                 \
                               &donor->lambda_3dup,                     \
                               &donor->num_thermal_pulses_since_mcmin,  \
                               &donor->spiky_luminosity,                \
                               &donor->SN_type,                         \
                               TRUE,                                    \
                               &(stardata->star[donor->starnum]),       \
                               stardata,                                \
                               STELLAR_STRUCTURE_CALLER_common_envelope_evolution); 


#define STELLAR_STRUCTUREnewtype                                        \
    {                                                                   \
    stellar_structure_longcall(&donor->phase_start_mass,                \
                               &donor->phase_start_core_mass,           \
                               &donor->age,                             \
                               &donor->mass,                            \
                               &tm1,                                    \
                               &tn,                                     \
                               tscls1,                                  \
                               lums,                                    \
                               GB,                                      \
                               &r1,                                     \
                               &l1,                                     \
                               &stellar_type,                           \
                               &donor->core_mass,                       \
                               &donor->CO_core_mass,                    \
                               &donor->GB_core_mass,                    \
                               &donor->max_MS_core_mass,                \
                               &rc1,                                    \
                               &menv,                                   \
                               &renv,                                   \
                               &k21,                                    \
                               &donor->time_first_pulse,                \
                               &donor->num_thermal_pulses,              \
                               &donor->time_prev_pulse,                 \
                               &donor->prev_tagb,                       \
                               &donor->menv_1tp,                        \
                               &donor->mc_1tp,                          \
                               &donor->core_mass_no_3dup,               \
                               &donor->interpulse_period,               \
                               &donor->time_next_pulse,                 \
                               &donor->lambda_3dup,                     \
                               &donor->num_thermal_pulses_since_mcmin,  \
                               &donor->spiky_luminosity,                \
                               &donor->SN_type,                         \
                               TRUE,                                    \
                               &(stardata->star[donor->starnum]),       \
                               stardata,                                \
                               STELLAR_STRUCTURE_CALLER_common_envelope_evolution); \
    }

#define TIMESCALES2                                             \
    stellar_timescales(accretor->stellar_type,                  \
                       accretor->phase_start_mass,              \
                       accretor->mass,                          \
                       &tm2,                                    \
                       &tn,                                     \
                       tscls2,                                  \
                       lums,                                    \
                       GB,                                      \
                       stardata,                                \
                       &(stardata->star[accretor->starnum]));


#define STELLAR_STRUCTURE2                                              \
    stellar_structure_longcall(&accretor->phase_start_mass,             \
                               &accretor->phase_start_core_mass,        \
                               &accretor->age,                          \
                               &accretor->mass,                         \
                               &tm2,                                    \
                               &tn,                                     \
                               tscls2,                                  \
                               lums,                                    \
                               GB,                                      \
                               &r2,                                     \
                               &l2,                                     \
                               &accretor->stellar_type,                 \
                               &accretor->core_mass,                    \
                               &accretor->CO_core_mass,                 \
                               &accretor->GB_core_mass,                 \
                               &accretor->max_MS_core_mass,             \
                               &rc2,                                    \
                               &menv,                                   \
                               &renv,                                   \
                               &k22,                                    \
                               &accretor->time_first_pulse,             \
                               &accretor->num_thermal_pulses,           \
                               &accretor->time_prev_pulse,              \
                               &accretor->prev_tagb,                    \
                               &accretor->menv_1tp,                     \
                               &accretor->mc_1tp,                       \
                               &accretor->core_mass_no_3dup,            \
                               &accretor->interpulse_period,            \
                               &accretor->time_next_pulse,              \
                               &accretor->lambda_3dup,                  \
                               &accretor->num_thermal_pulses_since_mcmin, \
                               &accretor->spiky_luminosity,             \
                               &accretor->SN_type,                      \
                               TRUE,                                    \
                               &(stardata->star[accretor->starnum]),    \
                               stardata,                                \
                               STELLAR_STRUCTURE_CALLER_common_envelope_evolution);



/*
 * Debugging output for star 1
 */

#define PRECALL1 printf("Precall &donor->age=%g m01=%g m1=%15.10e mc1=%15.10e (m1-mc1=%g) ntp=%g :: k21=%g l1=%g menv=%g r1=%15.10e rc1=%g renv=%g tm1=%g tn=%g st=%d\n", \
			donor->age,                                     \
			donor->phase_start_mass,                        \
			donor->mass,                                    \
			donor->core_mass,                               \
			donor->mass-donor->core_mass,                   \
			stardata->star[donor->starnum].num_thermal_pulses, \
			k21,						\
			l1,						\
			menv,						\
			r1,						\
			rc1,						\
			renv,						\
			tm1,						\
			tn,						\
			donor->stellar_type                             \
	);		


#define POSTCALL1 printf("Postcall &donor->age=%g m01=%g m1=%15.10e mc1=%15.10e (m1-mc1=%g) ntp=%g :: k21=%g l1=%g menv=%g r1=%15.10e rc1=%g renv=%g tm1=%g tn=%g st=%d\n", \
                         donor->age,                                    \
                         donor->phase_start_mass,                       \
                         donor->mass,                                   \
                         donor->core_mass,                              \
                         donor->mass-donor->core_mass,                  \
                         stardata->star[donor->starnum].num_thermal_pulses, \
                         k21,						\
                         l1,						\
                         menv,						\
                         r1,						\
                         rc1,						\
                         renv,						\
                         tm1,						\
                         tn,						\
                         donor->stellar_type                            \
	);		


/* debugging */
//#define STRUCTURE1  TIMESCALES1;PRECALL1; STELLAR_STRUCTURE1; POSTCALL1;

#define STRUCTURE1(DENY)                                                \
    {                                                                   \
        Boolean deny_was = stardata->model.deny_new_events;             \
        Set_event_denial(DENY);                                        \
        Dprint("1pre = { stellar_type=%d, m01=%g m1=%g r1=%g J1=%g }\n", \
               donor->stellar_type,                                     \
               donor->phase_start_mass,                                 \
               donor->mass,                                             \
               r1,                                                      \
               donor->angular_momentum);                                \
        TIMESCALES1;                                                    \
        STELLAR_STRUCTURE1;                                             \
        Dprint("1post = { stellar_type=%d, &donor->phase_start_mass=%g m1=%g tm1=%g tn=%g r1=%g rc1=%g l1=%g mc1=%g age=%g SN=%d J=%g }\n", \
               donor->stellar_type,                                     \
               donor->phase_start_mass,                                 \
               donor->mass,                                             \
               tm1,                                                     \
               tn,                                                      \
               r1,                                                      \
               rc1,                                                     \
               l1,                                                      \
               donor->core_mass,                                        \
               donor->age,                                              \
               donor->SN_type,                                          \
               donor->angular_momentum);                                \
        Set_event_denial(deny_was);                                    \
    }
#define STRUCTURE2(DENY)                                                \
    {                                                                   \
        Boolean deny_was = stardata->model.deny_new_events;             \
        Set_event_denial(DENY);                                        \
        stellar_type = accretor->stellar_type;                          \
        Dprint("2pre = { stellar_type=%d, &accretor->phase_start_mass=%g m2=%g mc2=%g r2=%g J2=%g }\n", \
               accretor->stellar_type,                                  \
               accretor->phase_start_mass,                              \
               accretor->mass,                                          \
               accretor->core_mass,                                     \
               r2,                                                      \
               accretor->angular_momentum);                             \
        TIMESCALES2;                                                    \
        STELLAR_STRUCTURE2;                                             \
        Dprint("2post = { stellar_type=%d, &accretor->phase_start_mass=%g m2=%g tm2=%g tn=%g r2=%g l2=%g mc2=%g age=%g SN=%d J=%g}\n", \
               accretor->stellar_type,                                  \
               accretor->phase_start_mass,                              \
               accretor->mass,                                          \
               tm2,                                                     \
               tn,                                                      \
               r2,                                                      \
               l2,                                                      \
               accretor->core_mass,                                     \
               accretor->age,                                           \
               accretor->SN_type,                                       \
               accretor->angular_momentum);                             \
               Set_event_denial(deny_was);                              \
   }


#ifdef POST_CE_ADAPTIVE_MENV

double stellar_radius(const int stellar_type,
                      const double mass,
                      const double mc,
                      const double lum,
                      const double age,
                      const double z,
                      struct star_t * star,
                      struct stardata_t * stardata
    );

double dmdr(struct star_t * star,
            struct stardata_t * stardata);


#endif // POST_CE_ADAPTIVE_MENV

#endif // COMMON_ENVELOPE_H
