#pragma once
#ifndef BUFFERING_PROTOTYPES_H
#define BUFFERING_PROTOTYPES_H

#include "../binary_c_structures.h"


int binary_c_API_function
binary_c_buffered_printf(struct stardata_t * RESTRICT const stardata,
                             const Boolean deslash,
                             const char * RESTRICT const format,
                             ...) Gnu_format_args(3,4);

void buffer_info(const struct stardata_t * RESTRICT const stardata,
                 char ** const buffer,
                 size_t * const size,
                 char ** const error_buffer);
void buffer_empty_buffer(struct stardata_t * RESTRICT const stardata);
void buffer_dump_to_stderr(const struct stardata_t * RESTRICT const stardata);

int binary_c_flush(const struct stardata_t * RESTRICT const stardata,
                   FILE * RESTRICT const stream);

void binary_c_fail_fprintf(struct stardata_t * RESTRICT const stardata,
                           const char * RESTRICT const filename ,
                           const int fileline,
                           const char * RESTRICT const format,
                           ...) Gnu_format_args(4,5) No_return;

void clear_printf_buffer(struct stardata_t * RESTRICT const stardata);
void clear_error_buffer(struct stardata_t * RESTRICT const stardata);



#endif // BUFFERING_PROTOTYPES_H
