#include "../binary_c.h"

double Pure_function white_dwarf_H_accretion_efficiency(const double Mdot_tr,
                                                        struct star_t * RESTRICT const donor,
                                                        struct star_t * RESTRICT const accretor)
{
    /*
     * Determine the efficiency of hydrogen accretion onto 
     * the WD. See Claeys et al 2014 (Appendix B).
     * which follows Hachisu et al. (1999) ApJ 522,487.
     */
    double efficiency;

    if(NAKED_HELIUM_STAR(donor->stellar_type))
    {
        efficiency = 1.0;
    }
    else
    {
        if(accretor->stellar_type == HeWD)
        {
            /* helium white dwarfs do not burn */
            efficiency = 0.0;
        }
        else
        {

            /* 
             * Maximum transfer rate C14 Eq. B.4 (Msun/year)
             */
            const double Mdot_cr_H = Hachisu_max_rate(donor,accretor);

/*
 * RGI: Joke's code read like this, but 
 * there's nothing in the paper (e.g. Eq. B.3) 
 * to back it up, so I commented this out
 */
/*
  if(Mdot_tr > 1e-4)
  {
  efficiency = 1.0;
  }
*/

            /* Eq. B.3 */
            efficiency = 
                (Mdot_tr > Mdot_cr_H) ? (Mdot_cr_H / Mdot_tr) :
                (Mdot_tr < Mdot_cr_H * 0.125) ? 0.0 :
                1.0;
        }

        /* must be in the range 0 .. 1 */
        Clamp(efficiency,0.0,1.0); 
    }    
    return efficiency;
}
                                          
