#ifndef TIDES_H
#define TIDES_H

/* BSE definition of when to allow tides */
#define DO_TIDES (                                                      \
        /* tides must be on */                                          \
        stardata->preferences->tidal_strength_factor>TINY               \
        &&                                                              \
        (                                                               \
            /* star is pre-WD */                                        \
            (                                                           \
                star->stellar_type<HeWD &&                              \
                More_or_equal(star->radius,1e-2*star->roche_radius)     \
                )                                                       \
            ||                                                          \
            /* or star is a WD donor */                                 \
            (star->stellar_type>=HeWD && k==ndonor)))

/* better: always do tides except for black holes and massless remnants */
#undef DO_TIDES
#define DO_TIDES (star->stellar_type < BLACK_HOLE)

#ifdef PRE_MAIN_SEQUENCE

/* Boolean to define a convective pre main sequence star */
#define CONVECTIVE_PMS (stardata->preferences->pre_main_sequence && \
			1e6 * star->age < preMS_lifetime(star->mass))

/* stars with M>1.25 are 'radiative' if they are not PreMS stars */
#define RADIATIVE_MAIN_SEQUENCE (star->stellar_type==MAIN_SEQUENCE	\
				 && !CONVECTIVE_PMS 			\
				 && More_or_equal(star->mass,1.25))	\

#else

/* standard definition */
#define RADIATIVE_MAIN_SEQUENCE (star->stellar_type==MAIN_SEQUENCE	\
				 && More_or_equal(star->mass,1.25))	\

#endif


#define USE_RADIATIVE_DAMPING (RADIATIVE_MAIN_SEQUENCE ||		\
			       (star->stellar_type==CHeB)||		\
			       (star->stellar_type==HeMS))

#define USE_CONVECTIVE_DAMPING (star->stellar_type<HeWD)

#endif // TIDES_H
