#include "../binary_c.h"

/*
 * Thermal mass transfer rate accretion limit
 * 
 * Ignored (set to VERY_LARGE_MASS_TRANSFER_RATE)
 * if the accretion_limit_thermal_multiplier is negative. 
 */
double Pure_function thermal_limit_for_accretion(struct star_t * RESTRICT accretor,
                                                 struct stardata_t * RESTRICT const stardata)
{
    return
        stardata->preferences->accretion_limit_thermal_multiplier < -TINY ?
        VERY_LARGE_MASS_TRANSFER_RATE :
        (accretor->mass/accretor->tkh
         *
         stardata->preferences->accretion_limit_thermal_multiplier);
}
