#include "../binary_c.h"

#define ORBITAL_PERIOD 1
#define ORBITAL_SEPARATION 2
#define ORBITAL_BOTH 3

void show_instant_RLOF_period_or_separation(struct stardata_t * RESTRICT const stardata)    
{
    /*
     * Given M1, M2, return the orbital period or separation that 
     * just avoids RLOF on the ZAMS
     */

    if(stardata->preferences->show_minimum_separation_for_instant_RLOF==TRUE ||
       stardata->preferences->show_minimum_orbital_period_for_instant_RLOF==TRUE)
    {
	/* check if we want separation or period */
        Star_number k;
	
	/*
	 * Choose the separation such that R1>ROL1 and R2>ROL2.
	 *
	 * NB this assumes a CIRCULAR ORBIT! 
	 *
	 * You have to correct if you want to start eccentric.
	 */

	/* 
	 * If M1=M2=0.1 (the minimum mass) then the minimum separation
	 * is 0.35days. We may as well start there (or at 0.3d) because 
	 * at higher mass the limit just increases.
	 *
	 * Set the step (dsep) to 0.01 days : accurate enough for government work! 
	 *
	 * Note: you could set up some kind of Newton-like method to
	 * zoom in more efficiently on the result. But why? This is very 
	 * quick and accurate enough.
	 *
	 * The overflow variable is true when either star overflows
	 * its Roche lobe
	 */
	stardata->common.orbit.separation = 0.3;
	double dsep = 0.01;
	Boolean overflow=TRUE;

	while(overflow==TRUE)
	{
	    Dprint("a=%g M1=%g R1=%g ROL1=%g : M2=%g R2=%g ROL2=%g : overflow? %d\n",
		   stardata->common.orbit.separation,
		   stardata->star[0].mass,
		   stardata->star[0].radius,
		   stardata->star[0].roche_radius,
		   stardata->star[1].mass,
		   stardata->star[1].radius,
		   stardata->star[1].roche_radius,
		   overflow);

	    /* still overflowing: increase the separation */
	    stardata->common.orbit.separation += dsep;
	    
	    /* recalculate the Roche radii */
	    determine_roche_lobe_radii(stardata,&stardata->common.orbit);

	    /* check for continuing overflow */
	    overflow = FALSE;
	    Starloop(k)
	    {
		overflow = overflow || 
		    (stardata->star[k].radius>stardata->star[k].roche_radius);
	    }
	}	      
	
	/* print the resulting period or separation */
        
        if(stardata->preferences->show_minimum_separation_for_instant_RLOF==TRUE)
	{
	    Printf("MINIMUM SEPARATION %g\n",stardata->common.orbit.separation);
	}
        
        if(stardata->preferences->show_minimum_orbital_period_for_instant_RLOF==TRUE)
        {
            Printf("MINIMUM PERIOD %g\n",calculate_orbital_period(stardata));
	}
	
	/* and exit */
 	Exit_or_return_void(BINARY_C_SPECIAL_EXIT,
                            "Exit after showing period or separation that just avoids RLOF");
    }
}
