#include "../binary_c.h"

/*
 * Set wind-accretion luminosities, 
 * designed to detect symbiotic systems.
 */
void set_wind_accretion_luminosities(struct stardata_t * RESTRICT const stardata)
{
    Star_number k;
    Starloop(k)
    {
        SETstar(k);
        star->accretion_luminosity = 3.14E+07*stardata->star[k].mass*
            (stardata->star[k].derivative[DERIVATIVE_STELLAR_MASS_WIND_GAIN] +
             stardata->star[k].derivative[DERIVATIVE_STELLAR_MASS_RLOF_GAIN])
            /stardata->star[k].radius;
    }
}
