#include "../binary_c.h"

void set_kelvin_helmholtz_times(struct stardata_t * RESTRICT const stardata)
{
    /*
     * Set Kelvin-Helmholtz times
     * (Hurley et al 2002, Eq.61)
     */
    Star_number k;
    Starloop(k)
    {
        SETstar(k);

        star->tkh = kelvin_helmholtz_time(star);

        Dprint("t=%g star %d tkh = %g from M=%g R=%g L=%g k=%d\n",
               stardata->model.time,
               star->starnum,
               star->tkh,
               star->mass,
               star->radius,
               star->luminosity,
               star->stellar_type
            );
        
        Nancheck(star->tkh);
    }
}
 
