#include "../binary_c.h"

double Constant_function rl(const double q
#ifdef RLOF_RADIATION_CORRECTION
                            ,const double f
#endif
    )
{
    /*
     * A function to evaluate R_L/a(q), Eggleton 1983.
     */
    double rlf;
    if(q<TINY)
    {
        rlf = 1e100;
    }
    else
    {
        const double p = cbrt(q);
        double pp = Pow2(p);
#ifdef RLOF_RADIATION_CORRECTION
        /*
         * Correction for radiation pressure : fit from Dermine Tyl's
         * pdf slides 
         */
        if(f>TINY)
        {
            double Af=0.49+
                0.08*f+
                -0.69*Pow2(f)+
                12.81*Pow3(f)+
                -75.50*Pow4(f)+
                208.14*Pow5(f)+
                -300.6*Pow6(f)+
                219.7*Pow7(f)+
                -64.27*Pow8(f);
            double Bf=0.6*(1.0+0.5*f);
            double Cf=1.0+f;
            rlf = Af*pp/(Bf*pp + log(1.0+Cf*p));
        }
        else
        {
            rlf = 0.49*pp/(0.6*pp + log(1.0+p));
        }
#else
        rlf = 0.49*pp/(0.6*pp + log(1.0+p));
#endif
    }
    return rlf;
}
