#include "../binary_c.h"

double Pure_function orbital_velocity_squared(struct stardata_t * RESTRICT const stardata)
{
    /* return the square of the orbital velocity (km^2/s^2) */
    double v2;
    if(Is_not_zero(stardata->common.orbit.separation))
    {
       
        
        v2 = fabs
            (1e-10 * GRAVITATIONAL_CONSTANT * 
             (stardata->star[0].mass+stardata->star[1].mass)*M_SUN/
             (stardata->common.orbit.separation*R_SUN));
    }
    else
    {
        v2 = 0.0;
    }
    return v2;
}
