#include "../binary_c.h"

void force_corotation_of_primary_and_orbit(struct stardata_t * RESTRICT const stardata)
{
    RLOF_stars;

    /*
     * Force co-rotation of primary and orbit to ensure that the tides do not
     * lead to unstable Roche.
     */
    stardata->model.iter = 0;
    stardata->model.coalesce=FALSE;
    
    /*BUG? Should naccretor be roche_radius as well? or ndonor radius?*/
    Dprint("effective_radius set 1, 1=%12.12g, 2=%12.12g\n",
           donor->roche_radius,
           accretor->radius);

    donor->effective_radius = Max(donor->roche_radius,donor->core_radius);
    accretor->effective_radius = accretor->radius;

#ifdef WD_KICKS
    if((stardata->star[0].stellar_type==TPAGB)&&
       (stardata->star[0].mass > 0.8*stardata->star[0].phase_start_mass)&&
       (stardata->preferences->wd_kick_when==WD_KICK_FIRST_RLOF))
    {
        stardata->star[0].kick_WD=TRUE;  
    }
#endif//WD_KICKS

}

