#include "../binary_c.h"
/*
 * Eddington accretion rate limit in Msun/year.
 * The radius (radius) and surface hydrogen mass fraction (X)
 * of the star must be passed in. If the accretion_limit_eddington_multiplier
 * is negative, return a very large rate so this is ignored.
 */

double Pure_function eddington_limit_for_accretion(const struct stardata_t * RESTRICT const stardata,
				     const double radius,
				     const Abundance X)
{

    return
        stardata->preferences->accretion_limit_eddington_multiplier < -TINY ?
        /* disabled by negative multiplier */
        VERY_LARGE_MASS_TRANSFER_RATE :
        /* zero or positive multiplier */
        (2.08e-03 * stardata->preferences->accretion_limit_eddington_multiplier *
         (1.0/(1.0 + X)) * radius);
}
