#include "../binary_c.h"

/*
 * Dynamical mass transfer rate accretion limit
 * 
 * Ignored (set to VERY_LARGE_MASS_TRANSFER_RATE)
 * if the accretion_limit_dynamical_multiplier is negative. 
 */
double Pure_function dynamical_limit_for_accretion(struct star_t * RESTRICT accretor,
                                     struct stardata_t * RESTRICT const stardata)
{
    return
        stardata->preferences->accretion_limit_dynamical_multiplier < -TINY ?
        VERY_LARGE_MASS_TRANSFER_RATE : 
        (accretor->mass/dynamical_timescale(accretor)
         *
         stardata->preferences->accretion_limit_dynamical_multiplier);
}
