#include "../binary_c.h"
/*
 * This function does whatever needs to be done for a contact binary system
 * (run away now, you have been warned!)
 */
#ifdef BSE
static void contact_system_call_corerd(const Star_number i,
                                       struct stardata_t * RESTRICT const stardata);
#endif
static Boolean contact_system_call_comenv(const Star_number ndonor,
                                          const Star_number naccretor,
                                          struct stardata_t * RESTRICT const stardata,
                                          const double rrl[]);
#ifdef BSE
static inline void set_epoch(struct stardata_t * RESTRICT const stardata,
                             struct star_t * star);

#endif

/************************************************************/



int contact_system(struct stardata_t * RESTRICT const stardata,
                   Boolean event_call)
{
    /*
     * If event_call is TRUE then we're called as the post-contact
     * system event. Otherwise, we set up the event which will be
     * triggered at the end of this timestep.
     */
    if(event_call == FALSE &&
       stardata->preferences->disable_events == FALSE)
    {
        /*
         * Set up the event
         */
        Dprint("Contact system : add new contact event (intermediate? %d)\n",
               stardata->model.intermediate_step);
        Add_new_event(stardata,
                      BINARY_C_EVENT_CONTACT_SYSTEM,
                      &contact_system_event_handler,
                      NULL,
                      NULL,
                      UNIQUE_EVENT);
        
        return NO_CONTACT;
    }
    else
    {
        /*
         * Do the contact
         */
        int action;
        Dprint("Check for contact : sgl = %d (stellar types %d %d)\n",
               stardata->model.sgl,
               stardata->star[0].stellar_type,
               stardata->star[1].stellar_type
            );
        if(stardata->model.sgl == FALSE)
        {
            double rrl[NUMBER_OF_STARS];
            double total_mass; /* used to speed things up */
            Star_number k;
  
            RLOF_stars;
            
            /*
             * Contact system
             */
            Dprint("in contact_system()\n");
            Append_logstring(LOG_CONTACT,"Contact reached R/RL = %g %g, st %d %d",
                             donor->roche_radius > 0.0 ? (donor->radius/donor->roche_radius) : 0.0,
                             accretor->roche_radius > 0.0 ? (accretor->radius/accretor->roche_radius) : 0.0,
                             accretor->stellar_type,
                             donor->stellar_type
                );
            stardata->model.coalesce = TRUE;

            /*
             * If either star is giant-like this will be common-envelope evolution.
             */
            Starloop(k)
            {
                rrl[k] = Min(999.999E0,
                             stardata->star[k].radius/stardata->star[k].roche_radius);
            }
    
            Starloop(k)
            {
                rrl[k] = Min(rrl[k],0.990);

                Dprint("Set rrl[%d]=%g\n",k,rrl[k]);
            }

            /*
             * The stars either go through common envelope evolution,
             * or they simply mix. 
             */
            Dprint("EVRLOF Comenv or mix?\n");
            if(contact_system_call_comenv(ndonor,naccretor,stardata,rrl)==FALSE 
               &&
               contact_system_call_comenv(naccretor,ndonor,stardata,rrl)==FALSE)
            {
                Dprint("EVRLOF MIX\n");
                stardata->common.orbit.separation = 0.0;
                mix_stars(stardata->star,stardata);
            }
            else
            {
                Dprint("EVRLOF COMENV\n");
            }
            
#ifdef BSE
            Starloop(k)
            {
                SETstar(k);
                set_epoch(stardata,star);
                Dprint("set epoch k=%d -> %g\n",k,star->epoch);
            }
#endif//BSE
            
            if(stardata->model.coalesce==FALSE)
            {
                Dprint("Contact system\n");
                if(stardata->common.orbit.eccentricity>1.0)
                {
#ifdef BSE
                    contact_system_call_corerd(0,stardata);
                    contact_system_call_corerd(1,stardata);
#endif//BSE      
                    action = SYSTEM_IS_BROKEN_APART;
                }
                else
                {
                    stardata->model.dtm = 0.0;
            
                    /*
                     * Reset orbital parameters as separation may have changed.
                     */
                    total_mass=Total_mass;
                    stardata->common.orbit.period = (stardata->common.orbit.separation/AU_IN_SOLAR_RADII)*
                        sqrt(stardata->common.orbit.separation/(AU_IN_SOLAR_RADII*total_mass));
                    stardata->common.orbit.angular_frequency = TWOPI/stardata->common.orbit.period;
            
                    action = END_ROCHE;
                }
            }
            else
            {
                /** return zero to indicate that we should do nothing **/
                action = BINARY_C_NORMAL_EXIT; 
            }
        }
        else
        {
            action = BINARY_C_NORMAL_EXIT;
        }
        return action;
    }

}


static inline void set_epoch(struct stardata_t * RESTRICT const stardata,
                             struct star_t * star)
{
    Dprint_no_newline(
        "Set epoch of star %d to t=%g - age=%g -> %g : was %g -> now ",
        star->starnum,         
        stardata->model.time,
        star->age,
        stardata->model.time - star->age,
        star->epoch);
    star->epoch = stardata->model.time - star->age;
    Dprint("%g\n",star->epoch);
}


#ifdef BSE
static void contact_system_call_corerd(const Star_number i,
                                       struct stardata_t * RESTRICT const stardata)
{
    double rc;

    if(stardata->star[i].stellar_type>=NEUTRON_STAR)
    {
        rc = corerd(stardata->star[i].stellar_type,
                    stardata->star[i].mass,
                    stardata->star[i].mass,
                    stardata->star[i].phase_start_core_mass,
                    stardata->common.metallicity_parameters[i],
                    stardata);
        
        stardata->star[i].omega = stardata->star[i].angular_momentum/(K3*rc*rc*stardata->star[i].mass);
    }
}
#endif//BSE
static Boolean contact_system_call_comenv(const Star_number ndonor,
                                          const Star_number naccretor,
                                          struct stardata_t * RESTRICT const stardata,
                                          const double rrl[])
                                          
{
    RLOF_stars_structs;
    double menv = donor->mass - donor->core_mass;

    /*
     * Check if either star is a giant, hence we have a common
     * envelope aroun the other(s), and that the envelope is massive
     * enough.
     */
    Dprint("ndonor %d, naccretor %d, donor %p, accretor %p, giant? %d, menv = %g vs %g -> %d\n",
           ndonor,
           naccretor,
           donor,
           accretor,
           GIANT_LIKE_STAR(donor->stellar_type),
           menv,
           stardata->preferences->minimum_donor_menv_for_comenv,
           menv > stardata->preferences->minimum_donor_menv_for_comenv);

    if(GIANT_LIKE_STAR(donor->stellar_type)
#ifdef POST_CEE_WIND_ONLY
       &&(menv > MIN_MENV_FOR_CEE)
#endif
       && (menv > stardata->preferences->minimum_donor_menv_for_comenv)
        )
    {
        Dprint("Call comenv from contact_system for giant-like star\n");
        common_envelope_evolution(
            donor,
            accretor,
            stardata
            );
#ifdef BSE
        update_MS_lifetimes(stardata);
#endif//BSE
        Dprint("post comenv ndonor=%d m1=%g m01=%g\n",
               ndonor,
               stardata->star[ndonor].mass,
               stardata->star[ndonor].phase_start_mass);

        stardata->model.com = TRUE;
        return(TRUE);
    }
    return(FALSE);
}
