#include "../binary_c.h"

void calculate_spins(struct stardata_t * RESTRICT const stardata)
{
    Star_number k;
    Starloop(k)
    {
	SETstar(k);
        star->omega = omegaspin(star);
        Dprint("Spin star %d (type %d) from j=%30.12e r=%g menv = %g - %g = %g I = %30.12e omega = %30.12e (omega orb %30.12e)\n",
               star->starnum,
               star->stellar_type,
               star->angular_momentum,
               star->radius,
               star->mass,
               star->core_mass,
               star->mass - star->core_mass,
               moment_of_inertia(star,star->effective_radius),
               star->omega,
               stardata->common.orbit.angular_frequency
            );        
        Nancheck(star->omega);
    }
}

