#include "../binary_c.h"

double Pure_function_if_no_debug calculate_orbital_period (struct stardata_t * RESTRICT const stardata)
{
    /* calculate the orbital period using Kepler's law, return it in days */

    double per=sqrt(Pow3(stardata->common.orbit.separation/
			 (double)AU_IN_SOLAR_RADII)/(Total_mass))
	*YEAR_LENGTH_IN_DAYS;
    
    Dprint("Calculating orbital period: %g (M1+M2=%g a=%g)\n",
           per,
           Total_mass,stardata->common.orbit.separation);

    return per;
}

