/*  Binary Star Evolution code */

/*  Header file for function prototypes */

/* filename: binary_star_functions.h */

/* version 1.0 */

/*******************************************/

#ifndef BINARY_STAR_FUNCTIONS_H
#define BINARY_STAR_FUNCTIONS_H

#include "../binary_c_code_options.h"

#include <sys/types.h>
#include "../binary_c_parameters.h"
#include "../binary_c_macros.h"
#include "../binary_c_structures.h"

int dgcore(const Stellar_type stellar_type1,
           const Stellar_type stellar_type2,
           Stellar_type * const stellar_type3,
           const double m1,
           const double m2,
           double * const m3,
           double * const ebinde,
           struct stardata_t * RESTRICT const stardata);

double Pure_function_if_no_debug calculate_orbital_separation(struct stardata_t * RESTRICT const stardata);
double Pure_function_if_no_debug calculate_orbital_period(struct stardata_t * RESTRICT const stardata);

void mix_stars(struct star_t *const star,
               struct stardata_t * const stardata);

#ifdef BSE
void mix_stars_BSE(struct star_t * const stars, 
                   struct stardata_t * const stardata);
#endif
#ifdef BINT
void mix_stars_BINT(struct star_t *const stars, 
                    struct stardata_t * const stardata);
#endif


double Constant_function rl(const double q
#ifdef RLOF_RADIATION_CORRECTION
                            ,const double f
#endif
    );

int contact_system(struct stardata_t * RESTRICT const stardata,
                   Boolean event_call);

void adjust_radius_derivative(struct stardata_t  * RESTRICT const stardata);

Boolean check_for_collision_at_periastron(struct stardata_t * RESTRICT const stardata);

void calc_wind_loss_and_gain_rates(struct stardata_t * RESTRICT const stardata,
                                   const Boolean RLOF_bool);

void set_ndonor_and_naccretor(struct stardata_t * RESTRICT const stardata);

double Pure_function wind_djorb_dt(const struct stardata_t * RESTRICT const stardata,
                                   double oorb);

void angular_momentum_loss_mechanisms_for_close_systems(struct stardata_t * RESTRICT const stardata);
			

void determine_mass_ratios(struct stardata_t * RESTRICT const stardata);

void determine_roche_lobe_radii(struct stardata_t * RESTRICT const stardata,
                                struct orbit_t * const orbit);

void determine_roche_lobe_radius(struct stardata_t * const stardata,
				 struct orbit_t * const orbit,
                                 struct star_t * const star);

void detached_limit_mass_loss_and_timestep(struct stardata_t * RESTRICT const stardata);

void save_detached_stellar_types(struct stardata_t * RESTRICT const stardata);

void adjust_radius_derivative(struct stardata_t * RESTRICT const stardata);

unsigned int test_for_roche_lobe_overflow(struct stardata_t * RESTRICT const stardata);
                    
void force_corotation_of_primary_and_orbit(struct stardata_t *  RESTRICT const stardata);
		

                          
void make_roche_lobe_radii_huge(struct stardata_t * RESTRICT const stardata);

void set_nuclear_timescale_and_slowdown_factor(struct stardata_t * RESTRICT const stardata);

void calculate_spins(struct stardata_t * RESTRICT const stardata);

void set_kelvin_helmholtz_times(struct stardata_t * RESTRICT const stardata);

unsigned int test_if_primary_still_fills_roche_lobe(struct stardata_t * RESTRICT const stardata);

void set_effective_radii(struct stardata_t * RESTRICT const stardata);

void detached_wind_loss_and_angmom_derivatives(struct stardata_t * RESTRICT const stardata);

void limit_timestep_to_2percent_ang_mom_change(struct stardata_t * RESTRICT const stardata);
                          
#ifdef BSE
void rejuvenate_MS_secondary_and_age_primary(struct stardata_t * RESTRICT const stardata);
#endif

void set_wind_accretion_luminosities(struct stardata_t * RESTRICT const stardata);

void angular_momentum_and_eccentricity_derivatives(struct stardata_t * RESTRICT const stardata,
                                                   const Boolean RLOF_boolean);

Constant_function double radius_closest_approach(const double sep,
                                                 const double q);

void tides(struct stardata_t * const stardata,
           const Boolean RLOF_boolean,
           const Star_number k,
           const double radius,
           struct star_t * const star,
           struct star_t * const companion);

Boolean prevent_overspin(struct star_t * const star,
                         struct stardata_t * const stardata,
                         const Boolean in_RLOF);

#ifdef CIRCUMBINARY_DISK_DERMINE
void circumbinary_disk(struct stardata_t * RESTRICT const stardata);
double circumbinary_disk_massloss_timescale(struct stardata_t  * RESTRICT const stardata);
#endif


double radius_stripped (const double phase_start_mass,
			const double tauMS,
			const double mass,
			const double rwas,
			struct star_t * const star,
			struct stardata_t * const stardata);

#ifdef WRLOF_MASS_TRANSFER
double WRLOF_rate(struct stardata_t * RESTRICT const stardata,
                  const Star_number k);
#endif
double Pure_function gravitational_radiation_jdot(struct stardata_t * RESTRICT const stardata);
double Pure_function gravitational_radiation_edot(struct stardata_t * RESTRICT const stardata);


void show_instant_RLOF_period_or_separation(struct stardata_t * RESTRICT const stardata);

double Pure_function orbital_velocity_squared(struct stardata_t * RESTRICT const stardata);
double Pure_function orbital_velocity(struct stardata_t * RESTRICT const stardata);

void stellar_wind_angmom(struct stardata_t * RESTRICT const stardata,
                         const Boolean RLOF_boolean,
                         const Star_number k);

double Pure_function wind_decc_dt(struct stardata_t * RESTRICT const stardata);

Boolean apply_orbital_angular_momentum_and_eccentricity_derivatives(struct stardata_t * RESTRICT const stardata,
                                                                    const Boolean RLOF_boolean);

int detached_apply_orbital_angular_momentum_and_eccentricity_derivatives(struct stardata_t * RESTRICT const stardata);

void apply_stellar_angular_momentum_and_mass_derivatives(struct stardata_t * RESTRICT const stardata,
                                                         const Boolean RLOF);

void detached_timestep_limits(struct stardata_t * RESTRICT const stardata);

int interpolate_R_to_RL(struct stardata_t * RESTRICT const stardata);
void handle_massless_remnants(struct stardata_t * RESTRICT const stardata);

double Pure_function radial_velocity_K(struct stardata_t * RESTRICT const stardata,
                                       const double inclination,
                                       const Star_number n);

void lagrange_points(const double M1,
                     const double M2,
                     const double separation,
                     struct coordinate_t L[NUMBER_OF_LAGRANGE_POINTS],
                     double * RESTRICT const a1,
                     double * RESTRICT const a2
    );
void lagrange_points_from_stardata(struct stardata_t * RESTRICT const stardata,
                                   struct coordinate_t L[NUMBER_OF_LAGRANGE_POINTS],
                                   double * RESTRICT const a1,
                                   double * RESTRICT const a2);


int mass_angmom_and_evolutionary_changes(struct stardata_t * RESTRICT const stardata,
                                         const Evolution_system_type system_type);


void apply_stellar_mass_and_angular_momentum_derivatives(struct stardata_t * stardata,
                                                         const Boolean RLOF);


double non_conservative_gamma(struct stardata_t * RESTRICT const stardata,
                              struct star_t * const donor,
                              struct star_t * const accretor
           
    );
void non_conservative_angular_momentum_loss(struct stardata_t * RESTRICT const stardata,
                                            const Boolean RLOF);
void compact_object_accretion_limits(struct stardata_t * const stardata,
                                     struct star_t * const accretor,
                                     struct star_t * const donor,
                                     double * RESTRICT const steady_burn_rate,
                                     double * RESTRICT const new_envelope_rate);

double WD_max_accretion_rate(struct stardata_t * RESTRICT const stardata,
                             struct star_t * const donor,
                             struct star_t * const accretor);

double WD_min_accretion_rate(struct stardata_t * RESTRICT const stardata,
                             struct star_t * const donor,
                             struct star_t * const accretor);


void limit_accretion_rates(struct stardata_t * RESTRICT const stardata);

int update_masses_angular_momenta_and_structure(struct stardata_t * RESTRICT const stardata,
                                                const Boolean RLOF);
double Pure_function eddington_limit_for_accretion(const struct stardata_t * RESTRICT const stardata,
                                                   const double radius,
                                                   const Abundance X);
double Pure_function thermal_limit_for_accretion(struct star_t * RESTRICT accretor,
                                                 struct stardata_t * RESTRICT const stardata);

double Pure_function dynamical_limit_for_accretion(struct star_t * RESTRICT accretor,
                                                   struct stardata_t * RESTRICT const stardata);


double Pure_function white_dwarf_H_accretion_efficiency(const double Mdot_tr,
                                                        struct star_t * RESTRICT const donor,
                                                        struct star_t * RESTRICT const accretor);
double Pure_function white_dwarf_He_accretion_efficiency(const double transfer_rate,
                                                         struct star_t * MAYBE_UNUSED RESTRICT const donor,
                                                         struct star_t * RESTRICT const accretor,
                                                         struct stardata_t * RESTRICT const stardata);

double Pure_function binary_a_n(struct stardata_t * const stardata,
                                struct star_t * const star);
#ifdef BSE
void update_MS_lifetimes(struct stardata_t * RESTRICT const stardata);
#endif//BSE
double Peters_grav_wave_merger_time(const struct stardata_t * RESTRICT const stardata,
                                    const double m1,
                                    const double m2,
                                    const double a,
                                    const double ecc);


void apply_other_stellar_derivatives(struct stardata_t * RESTRICT const stardata,
                                     const Boolean RLOF);

Event_handler_function contact_system_event_handler(void * eventp,
                                                    struct stardata_t * stardata,
                                                    void * data);

double spiral_in_time(struct stardata_t * RESTRICT const stardata);

#endif /*BINARY_STAR_FUNCTIONS_H*/

