#include "../binary_c.h"
/*
 * Every timestep, apply derivatives which are not
 * mass and angular momentum.
 */

void apply_other_stellar_derivatives(struct stardata_t * RESTRICT const stardata,
                                     const Boolean RLOF)
{
     /*
     * Timestep
     */
    double dt MAYBE_UNUSED = RLOF==TRUE ? (stardata->model.dtm*1e6) : stardata->model.dt;

#ifdef REVERSE_TIME
    if(stardata->preferences->reverse_time == TRUE)
    {
        dt *= -1;
        dtm *= -1;
    }
#endif//REVERSE_TIME
    
#ifdef BINT
    Star_number k;
    Evolving_STARLOOP(k)
    {
        SETstar(k);

        /*
         * Burn central hydrogen to helium
         */
        apply_derivative(stardata,
                         &star->bint.XHc,
                         star->derivative,
                         dt,
                         DERIVATIVE_STELLAR_CENTRAL_HYDROGEN);
        apply_derivative(stardata,
                         &star->bint.XHec,
                         star->derivative,
                         -dt,
                         DERIVATIVE_STELLAR_CENTRAL_HYDROGEN);
        Clamp(star->bint.XHc,0.0,1.0);
        Clamp(star->bint.XHec,0.0,1.0);
    }
#endif //BINT
}
