#include "../binary_c.h"


Boolean apply_orbital_angular_momentum_and_eccentricity_derivatives(struct stardata_t * RESTRICT const stardata,
                                                                    const Boolean RLOF_boolean)
{

    /*
     * Apply orbital angular momentum and eccentricity derivatives, 
     * as well as update circumbinary discs
     */
    struct common_t *common = &stardata->common;
    double awas = common->orbit.separation;
    double dt = stardata->model.dt;
#ifdef REVERSE_TIME
    if(stardata->preferences->reverse_time == TRUE)
    {
        dt *= -1.0;
    }
#endif//REVERSE_TIME    
    /*
     * Eccentricity 
     */
    apply_derivative(stardata,
                     &common->orbit.eccentricity,
                     stardata->model.derivative,
                     dt,
                     DERIVATIVE_ORBIT_ECCENTRICITY);
        
    common->orbit.eccentricity = Max(common->orbit.eccentricity,0.0);

    /* close to zero, set the eccentricity to zero */
    if(Abs_less_than(common->orbit.eccentricity,TINY_ECCENTRICITY)) 
        common->orbit.eccentricity=0.0;
    Nancheck(common->orbit.eccentricity);
    
    /* unbound system */
    if(RLOF_boolean && More_or_equal(common->orbit.eccentricity,1.0))
    { 
        Dprint("End RLOF because e = %g > 1",common->orbit.eccentricity);
        return END_RLOF;
    }
       
    if(stardata->model.sgl==FALSE)
    {
        /*
         * Angular momentum
         */

        Dprint("pre-update apply dJorb/dt : dJorb/dt = %g\n",
               stardata->model.derivative[DERIVATIVE_ORBIT_ANGMOM]);
       
        apply_derivative(stardata,
                         &stardata->common.orbit.angular_momentum,
                         stardata->model.derivative,
                         dt,
                         DERIVATIVE_ORBIT_ANGMOM);

        Dprint("post-update apply dJorb/dt : dJorb/dt = %g\n",
               stardata->model.derivative[DERIVATIVE_ORBIT_ANGMOM]);
        

        /*
         * Sometimes the angular momentum is slightly less
         * than zero. This is often alleviated by setting
         * a smaller timestep, however the result is the same:
         * a contact system.
         */
        Clamp(common->orbit.angular_momentum,
              MINIMUM_ORBITAL_ANGMOM,
              MAXIMUM_ORBITAL_ANGMOM);

        Nancheck(common->orbit.angular_momentum);
        Dprint("pre-update orbital variables: dJorb/dt = %g\n",
               stardata->model.derivative[DERIVATIVE_ORBIT_ANGMOM]);
        update_orbital_variables(stardata,
                                 &common->orbit,
                                 &stardata->star[0],
                                 &stardata->star[1]);
        
        Dprint("pre-update orbital variables: dJorb/dt = %g\n",
               stardata->model.derivative[DERIVATIVE_ORBIT_ANGMOM]);
    }
    else
    {
        /* single stars : eccentricity is "-1.0" */
        common->orbit.angular_momentum = 0.0;
        common->orbit.eccentricity = -1.0;
    }
    
    stardata->model.derivative[DERIVATIVE_ORBIT_SEMI_MAJOR_AXIS] =
        (stardata->model.dtm > TINY) ? 
        (common->orbit.separation - awas)/(1e6*stardata->model.dtm) : 0.0;


    /*
     * Test variable : d/dt = 1, so this should just be the age
     */
    stardata->model.derivative[DERIVATIVE_SYSTEM_TEST] = 1.0;
    apply_derivative(stardata,
                     &common->test,
                     stardata->model.derivative,
                     dt,
                     DERIVATIVE_SYSTEM_TEST);

#ifdef DISCS
    /*
     * Circumbinary discs
     */
    {
        //int i;
    }

#endif
    

    return RLOF_boolean ? CONTINUE_RLOF : TRUE;
}
